<!-- PLUGIN SETTINGS -->

<!-- Woocommerce templates -->
<?php

// include only when WooCommerce is active
if ( td_global::$is_woocommerce_installed === true ) {
    echo td_panel_generator::box_start('قالب های ووکامرس');
?>

    <!-- Shop product categories archives - custom sidebar + position -->
    <div class="td-box-row td-woo-categories-archives-box-row hide-settings tdb-hide">
        <div class="td-box-description">
            <p>نوار کناری و موقعیت صفحات دسته‌بندی ووکامرس را تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
				<?php
				echo td_panel_generator::visual_select_o(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_archive_cat_sidebar_pos',
					'values' => array(
						array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
						array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
						array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
					)
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
				<?php
				echo td_panel_generator::sidebar_pulldown(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_archive_cat_sidebar'
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>
    <div class="td-box-section-separator"></div>

    <!-- Shop product tags archives - custom sidebar + position -->
    <div class="td-box-row td-woo-tags-archives-box-row hide-settings tdb-hide">
        <div class="td-box-description">
            <p>نوار کناری و موقعیت صفحات برچسب های ووکامرس را تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
				<?php
				echo td_panel_generator::visual_select_o(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_archive_tag_sidebar_pos',
					'values' => array(
						array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
						array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
						array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
					)
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
				<?php
				echo td_panel_generator::sidebar_pulldown(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_archive_tag_sidebar'
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>
    <div class="td-box-section-separator"></div>

    <!-- Shop product attributes archives - custom sidebar + position -->
    <div class="td-box-row td-woo-attributes-archives-box-row hide-settings tdb-hide">
        <div class="td-box-description">
            <p>نوار کناری و موقعیت صفحات ویژگی های ووکامرس را تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
				<?php
				echo td_panel_generator::visual_select_o(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_archive_atts_sidebar_pos',
					'values' => array(
						array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
						array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
						array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
					)
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
				<?php
				echo td_panel_generator::sidebar_pulldown(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_archive_atts_sidebar'
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>
    <div class="td-box-section-separator"></div>

    <!-- Shop search - custom sidebar + position -->
    <div class="td-box-row td-woo-search-archives-box-row hide-settings tdb-hide">
        <div class="td-box-description">
            <p>نوار کناری و موقعیت سفارشی را برای صفحه جستجوی ووکامرس تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
				<?php
				echo td_panel_generator::visual_select_o(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_search_sidebar_pos',
					'values' => array(
						array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
						array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
						array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
					)
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
				<?php
				echo td_panel_generator::sidebar_pulldown(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_search_sidebar'
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>
    <div class="td-box-section-separator"></div>

    <!-- Shop single product page - custom sidebar + position -->
    <div class="td-box-row td-single-products-box-row hide-settings tdb-hide">
        <div class="td-box-description">
            <p>نوار کناری و موقعیت سفارشی را برای صفحات تک محصولی ووکامرس تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
				<?php
				echo td_panel_generator::visual_select_o(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_single_sidebar_pos',
					'values' => array(
						array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
						array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
						array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
					)
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
				<?php
				echo td_panel_generator::sidebar_pulldown(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_single_sidebar'
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>
    <div class="td-box-section-separator"></div>

    <!-- Shop base page - custom sidebar + position -->
    <div class="td-box-row td-woo-shop-base-box-row hide-settings tdb-hide">
        <div class="td-box-description">
            <p>نوار کناری و موقعیت سفارشی را برای صفحه اصلی فروشگاه ووکامرس تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
				<?php
				echo td_panel_generator::visual_select_o(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_shop_base_sidebar_pos',
					'values' => array(
						array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
						array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
						array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
					)
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
				<?php
				echo td_panel_generator::sidebar_pulldown(array(
					'ds' => 'td_option',
					'option_id' => 'tds_woo_shop_base_sidebar'
				));
				?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

	<?php echo td_panel_generator::box_end();

    echo td_panel_generator::box_start('تنظیمات ووکامرس', false);
}
?>
<!-- Enable mobile -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش قیمت بدون مالیات</span>
        <p>نمایش یا پنهان کردن قیمت بدون مالیات. در صورتی که قیمت را با مالیات نشان می دهید، می توانید نمایش قیمت بدون مالیات را نیز فعال کنید.</p>
        <p>در کدهای کوتاه زیر ظاهر می شود:</p>
        <ul>
            <li>قیمت محصول ووکامرس</li>
            <li>افزودن به سبد خرید</li>
            <li>بلوک محصولات ووکامرس</li>
            <li>حلقه ووکامرس</li>
        </ul>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_woo_price_excl_tax',
            'true_value' => 'yes',
            'false_value' => ''
        ));
        ?>
    </div>
</div>
<div class="td-box-section-separator"></div>

<!-- Enable product images zoom -->
<div class="td-box-row">
    <div class="td-box-description">
    <span class="td-box-title">اثر زوم تصویر محصول</span>
    <p>غیرفعال کردن این گزینه باعث حذف جلوه زوم از تصویر محصول می شود.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_woo_prod_img_zoom',
            'true_value' => '',
            'false_value' => 'yes'
        ));
        ?>
    </div>
</div>
<div class="td-box-section-separator"></div>

<!-- Enable/Disable products linked variations -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">متغییر های لینک شده</span>
        <p>این ویژگی به شما امکان می‌دهد نوع جدیدی از محصول متغیر را بر اساس محصولات ساده ایجاد کنید. می‌توانید بسته‌های تغییرات مرتبط را از طریق داشبورد -> محصولات -> تغییرات مرتبط ایجاد کنید. اطلاعات بیشتر را در مستندات ما بخوانید.</p>
    </div>
    <div class="td-box-control-full">
        <?php

        //td_util::update_option( 'td_woo_linked_variations', '' );

        $true_value = 'yes';
        $td_woo_linked_variations = td_util::get_option( 'td_woo_linked_variations' );
        //echo '<pre>' .print_r($td_woo_linked_variations,true) . '</pre>';
        if ( empty($td_woo_linked_variations) ) {
            $true_value = '';
        }

        echo td_panel_generator::checkbox( array(
            'ds' => 'td_option',
            'option_id' => 'td_woo_linked_variations',
            'true_value' => $true_value,
            'false_value' => 'no'
        ));
        ?>
    </div>
</div>

<!-- Enable/Disable Woocommerce extended compatibility mode -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">حالت سازگاری توسعه‌یافته</span>
        <p>این ویژگی سازگاری بیشتری را برای افزونه‌های شخص ثالث (مثلاً دکمه‌های لیست علاقه‌مندی/مقایسه، نشان‌ها، افزونه‌های محصول) فراهم می‌کند و هنگام استفاده از توضیحات محصول وو در قالب تک محصول، مانند قالب پیش‌فرض وو نمایش داده می‌شوند. این گزینه را غیرفعال بگذارید مگر اینکه به آن نیاز داشته باشید - فعال کردن آن ممکن است عناصری را که قبلاً با بلوک‌های روزنامه نمایش می‌دهید، کپی کند.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox( array(
            'ds' => 'td_option',
            'option_id' => 'td_woo_extended_compatibility',
            'true_value' => 'yes',
            'false_value' => 'no'
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end();


