<?php
/*
Plugin Name: Cali Sight Plugin
Plugin URI: http://tagdiv.com
Description: tagDiv plugin for demos with custom post types & taxonomies
Author: tagDiv
Version: 1.0.0
Author URI: http://tagdiv.com
*/

defined( 'ABSPATH' ) || exit;

add_action( 'tdc_init', function() {
	new td_cali_sight_demo_plugin();
}, 11 );

class td_cali_sight_demo_plugin {

	var $plugin_url = '';
	var $plugin_path = '';

	public function __construct() {
		$this->plugin_url = plugins_url(__FILE__ );
		$this->plugin_path = dirname(__FILE__ );


		/**
		 * ACF
		 */

		// this will allow custom fields meta box on posts when the acf plugin is active
		add_filter( 'acf/settings/remove_wp_meta_box', '__return_false' );

		// add local acf fields
		add_action( 'init', array( $this, 'acf_add_local_field_groups' ) );

		// export acf fields: (via json sync)
		add_filter( 'acf/settings/save_json', array( $this, 'set_acf_json_save_folder' ) );
		add_filter( 'acf/settings/load_json', array( $this, 'add_acf_json_load_folder' ) );

		// sync json acf-json fields @see td-demo/includes/acf-json
		add_action( 'admin_init', array( $this, 'sync_acf_fields' ) );

		/**
		 * CPT UI
		 */
		add_action( 'after_setup_theme',  function () {
            // we need priority 9, to avoid invalid tax error
			add_action( 'init', array( $this, 'cptui_register_my_cpts' ), 9 );
			add_action( 'init', array( $this, 'cptui_register_my_taxes' ), 9 );
		});

	}

	public function set_acf_json_save_folder( $path ) {
		return $this->plugin_path . '/includes/acf-json';
	}

	public function add_acf_json_load_folder( $paths ) {
		unset( $paths[0] );

		$paths[] = $this->plugin_path . '/includes/acf-json';

		return $paths;
	}

	public function acf_add_local_field_groups() {

		/*
		 * ACF > Export Field Groups - Generated PHP goes here
		 */

	}

	public function sync_acf_fields() {

		if( ! function_exists('acf_get_field_groups' ) )
			return;

		$groups = acf_get_field_groups();
		$sync = array();

		// return here if no field groups
		if( empty( $groups ) )
			return;

		// find json field groups which have not yet been imported
		foreach( $groups as $group ) {
			$local    = acf_maybe_get( $group, 'local', false );
			$modified = acf_maybe_get( $group, 'modified', 0 );
			$private  = acf_maybe_get( $group, 'private', false );

			// ignore db/php/private field groups
			if( $local !== 'json' || $private ) {
				// do nothing
				continue;
			// append to sync if not yet in database
			} elseif( ! $group['ID'] ) {
				$sync[ $group['key'] ] = $group;
			// append to sync if "json" modified time is newer than database
			} elseif( $modified && $modified > get_post_modified_time( 'U', true, $group['ID'], true ) ) {
				$sync[ $group['key'] ]  = $group;
			}
		}

		// return here if no sync needed
		if( empty( $sync ) )
			return;

		foreach( $sync as $key => $v ) {

			// append fields
			if( acf_have_local_fields( $key ) ) {
				$sync[$key]['fields'] = acf_get_local_fields( $key );
			}

			// import
			$field_group = acf_import_field_group( $sync[$key] );

		}

	}

	// register cptui post types
	function cptui_register_my_cpts() {

            /**
             * Post Type: Tourism.
             */

            $labels = [
                "name" => esc_html__( "گردشگری", "newspaper" ),
                "singular_name" => esc_html__( "گردشگری", "newspaper" ),
                "menu_name" => esc_html__( "گردشگری من", "newspaper" ),
                "all_items" => esc_html__( "تمام گردشگری", "newspaper" ),
                "add_new" => esc_html__( "جدید اضافه کنید", "newspaper" ),
                "add_new_item" => esc_html__( "گردشگری جدید اضافه کنید", "newspaper" ),
                "edit_item" => esc_html__( "ویرایش گردشگری", "newspaper" ),
                "new_item" => esc_html__( "گردشگری جدید", "newspaper" ),
                "view_item" => esc_html__( "مشاهده گردشگری", "newspaper" ),
                "view_items" => esc_html__( "مشاهده گردشگری", "newspaper" ),
                "search_items" => esc_html__( "جستجوی گردشگری", "newspaper" ),
                "not_found" => esc_html__( "گردشگری پیدا نشد", "newspaper" ),
                "not_found_in_trash" => esc_html__( "هیچ گردشگری در سطل زباله یافت نشد", "newspaper" ),
                "parent" => esc_html__( "گردشگری والد:", "newspaper" ),
                "featured_image" => esc_html__( "تصویر ویژه این گردشگری", "newspaper" ),
                "set_featured_image" => esc_html__( "تنظیم تصویر برجسته برای این گردشگری", "newspaper" ),
                "remove_featured_image" => esc_html__( "حذف تصویر برجسته برای این گردشگری", "newspaper" ),
                "use_featured_image" => esc_html__( "به عنوان تصویر برجسته برای این گردشگری استفاده کنید", "newspaper" ),
                "archives" => esc_html__( "آرشیو گردشگری", "newspaper" ),
                "insert_into_item" => esc_html__( "وارد کردن به گردشگری", "newspaper" ),
                "uploaded_to_this_item" => esc_html__( "در این گردشگری آپلود کنید", "newspaper" ),
                "filter_items_list" => esc_html__( "لیست گردشگری را فیلتر کنید", "newspaper" ),
                "items_list_navigation" => esc_html__( "پیمایش لیست گردشگری", "newspaper" ),
                "items_list" => esc_html__( "لیست گردشگری", "newspaper" ),
                "attributes" => esc_html__( "ویژگی های گردشگری", "newspaper" ),
                "name_admin_bar" => esc_html__( "گردشگری", "newspaper" ),
                "item_published" => esc_html__( "گردشگری منتشر شد", "newspaper" ),
                "item_published_privately" => esc_html__( "Tگردشگری به صورت خصوصی منتشر شد", "newspaper" ),
                "item_reverted_to_draft" => esc_html__( "گردشگری به پیش نویس بازگشت.", "newspaper" ),
                "item_scheduled" => esc_html__( "گردشگری برنامه ریزی شده ", "newspaper" ),
                "item_updated" => esc_html__( "گردشگری به روز شد", "newspaper" ),
                "parent_item_colon" => esc_html__( "گردشگری والد:", "newspaper" ),
            ];

            $args = [
                "label" => esc_html__( "گردشگری", "newspaper" ),
                "labels" => $labels,
                "description" => "",
                "public" => true,
                "publicly_queryable" => true,
                "show_ui" => true,
                "show_in_rest" => true,
                "rest_base" => "",
                "rest_controller_class" => "WP_REST_Posts_Controller",
                "rest_namespace" => "wp/v2",
                "has_archive" => false,
                "show_in_menu" => true,
                "show_in_nav_menus" => true,
                "delete_with_user" => false,
                "exclude_from_search" => false,
                "capability_type" => "post",
                "map_meta_cap" => true,
                "hierarchical" => false,
                "can_export" => false,
                "rewrite" => [ "slug" => "tdcpt_tourism", "with_front" => true ],
                "query_var" => true,
                "supports" => [ "title", "editor", "thumbnail", "excerpt", "custom-fields", "revisions" ],
                "show_in_graphql" => false,
            ];

            register_post_type( "tdcpt_tourism", $args );
    }


	// register cptui taxonomies
    function cptui_register_my_taxes() {

        /**
         * Taxonomy: Attractions.
         */

        $labels = [
            "name" => esc_html__( "جاذبه ها", "newspaper" ),
            "singular_name" => esc_html__( "جاذبه", "newspaper" ),
            "menu_name" => esc_html__( "جاذبه ها", "newspaper" ),
            "all_items" => esc_html__( "همه جاذبه ها", "newspaper" ),
            "edit_item" => esc_html__( "ویرایش جاذبه ها", "newspaper" ),
            "view_item" => esc_html__( "مشاهده جاذبه", "newspaper" ),
            "update_item" => esc_html__( "به روز رسانی نام جاذبه", "newspaper" ),
            "add_new_item" => esc_html__( "افزودن جاذبه جدید", "newspaper" ),
            "new_item_name" => esc_html__( "نام جاذبه جدید", "newspaper" ),
            "parent_item" => esc_html__( "جاذبه والد", "newspaper" ),
            "parent_item_colon" => esc_html__( "جاذبه والد:", "newspaper" ),
            "search_items" => esc_html__( "جستجوی جاذبه ها", "newspaper" ),
            "popular_items" => esc_html__( "جاذبه های محبوب", "newspaper" ),
            "separate_items_with_commas" => esc_html__( "جاذبه ها را با کاما جدا کنید", "newspaper" ),
            "add_or_remove_items" => esc_html__( "اضافه یا حذف کنید Attractions", "newspaper" ),
            "choose_from_most_used" => esc_html__( "از پر استفاده ترین جاذبه ها انتخاب کنید", "newspaper" ),
            "not_found" => esc_html__( "هیچ جاذبه ای یافت نشد", "newspaper" ),
            "no_terms" => esc_html__( "بدون جاذبه", "newspaper" ),
            "items_list_navigation" => esc_html__( "ناوبری لیست جاذبه ها", "newspaper" ),
            "items_list" => esc_html__( "لیست جاذبه ها", "newspaper" ),
            "back_to_items" => esc_html__( "بازگشت به جاذبه ها", "newspaper" ),
            "name_field_description" => esc_html__( "نام این است که چگونه در سایت شما ظاهر می شود.", "newspaper" ),
            "parent_field_description" => esc_html__( "برای ایجاد یک سلسله مراتب یک عبارت والد اختصاص دهید. برای مثال، اصطلاح جاز، والد Bebop و Big Band است.", "newspaper" ),
            "slug_field_description" => esc_html__( "Slug نسخه URL پسند نام است. معمولا تمام حروف کوچک است و فقط شامل حروف، اعداد و خط فاصله است.", "newspaper" ),
            "desc_field_description" => esc_html__( "شرح به طور پیش فرض برجسته نیست. با این حال، برخی از موضوعات ممکن است آن را نشان دهد.", "newspaper" ),
        ];


        $args = [
            "label" => esc_html__( "جاذبه ها", "newspaper" ),
            "labels" => $labels,
            "public" => true,
            "publicly_queryable" => true,
            "hierarchical" => true,
            "show_ui" => true,
            "show_in_menu" => true,
            "show_in_nav_menus" => true,
            "query_var" => true,
            "rewrite" => [ 'slug' => 'tdtax_attractions', 'with_front' => true, ],
            "show_admin_column" => false,
            "show_in_rest" => true,
            "show_tagcloud" => false,
            "rest_base" => "tdtax_attractions",
            "rest_controller_class" => "WP_REST_Terms_Controller",
            "rest_namespace" => "wp/v2",
            "show_in_quick_edit" => false,
            "sort" => false,
            "show_in_graphql" => false,
        ];
        register_taxonomy( "tdtax_attractions", [ "tdcpt_tourism" ], $args );
    }

}
