<!-- HEADER STYLE -->

<?php

$tdb_header_template_is_set = false;

if (td_global::is_tdb_registered()) {

    $tdb_header_templates = array();

    // read the tdb category templates
    $wp_query_templates = new WP_Query(
        array(
            'post_type' => 'tdb_templates',
            'posts_per_page' => -1
        )
    );

    if (!empty($wp_query_templates->posts)) {

        foreach ($wp_query_templates->posts as $post) {

            $tdb_template_type = get_post_meta($post->ID, 'tdb_template_type', true);
            $meta_is_mobile_template = get_post_meta($post->ID, 'tdc_is_mobile_template', true);

            if ($tdb_template_type === 'header' && (empty($meta_is_mobile_template) || '0' === $meta_is_mobile_template)) {
                $tdb_header_templates[] = array(
                    'text' => $post->post_title,
                    'val' => 'tdb_template_' . $post->ID
                );
            }

            $tdb_header_template = td_options::get('tdb_header_template');

            if ($tdb_template_type === 'header' && $tdb_header_template === 'tdb_template_' . $post->ID) {
                $tdb_header_template_is_set = true;
            }
        }
    }


?>

    <!-- Cloud Library Category template -->
    <?php echo td_panel_generator::box_start(); ?>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">الگوی کتابخانه ابری</span>
            <p>انتخاب یک <a href="<?php echo admin_url('admin.php?page=tdb_cloud_templates') ?>" target="_blank">الگوی سرصفحه کتابخانه ابری</a> برای همه وب‌سایت‌ها.</p>
        </div>
        <div class="td-box-control-full">

            <?php

            $option_id = 'tdb_header_template';
            if (class_exists('SitePress', false)) {
                global $sitepress;
                $sitepress_settings = $sitepress->get_settings();
                if (isset($sitepress_settings['custom_posts_sync_option']['tdb_templates'])) {
                    $translation_mode = (int)$sitepress_settings['custom_posts_sync_option']['tdb_templates'];
                    if (1 === $translation_mode) {
                        $option_id .= $sitepress->get_current_language();
                    }
                }
            }

            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => $option_id,
                'values' => array_merge(
                    array(
                        array('text' => '- No Template -', 'val' => ''),
                    ),
                    $tdb_header_templates
                )
            ));

            ?>

        </div>
    </div>
    <?php echo td_panel_generator::box_end(); ?>
    <hr>
<?php } ?>

<?php
if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) {

    echo td_panel_generator::box_start('استایل هدر', true, 'tdb-hide'); ?>

    <!-- HEADER STYLE -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">استایل هدر</span>
            <p>ترتیب چیدمان عناصر هدر را انتخاب کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_header_style',
                'values' => td_api_header_style::_helper_generate_tds_header_style()
            ));
            ?>
        </div>
    </div>

    <?php
    if ('Newspaper' == TD_THEME_NAME) { ?>
        <!-- SEARCH POSITION -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">موقعیت جستجو</span>
                <p>ناحیه قرارگیری دکمه جستجو را انتخاب کنید</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::radio_button_control(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_search_placement',
                    'values' => array(
                        array('text' => '<strong>منوی اصلی</strong> - Default', 'val' => ''),
                        array('text' => '<strong>نوار بالا</strong>', 'val' => 'top_bar'),
                        array('text' => '<strong>پنهان</strong>', 'val' => 'hide')
                    )
                ));
                ?>
            </div>
        </div>
    <?php } ?>


    <?php echo td_panel_generator::box_end(); ?>


    <!-- TOP BAR -->
    <?php echo td_panel_generator::box_start('نوار بالا', false, 'tdb-hide'); ?>


    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <p>
                نوار بالا منوی بالای سیاه است. زمانی که می خواهید یک گزینه <i>ورود به سیستم اجتماعی اضافه کنید بسیار مفید است
                    نمادها</i> و صفحاتی مانند <i>درباره ما، تماس با ما و غیره.</i>.
            </p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <!-- Top bar: enable disable -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نوار بالا را فعال کنید</span>
            <p>نوار را پنهان یا نمایش دهید.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_top_bar',
                'true_value' => '',
                'false_value' => 'hide_top_bar'
            ));
            ?>
        </div>
    </div>


    <?php if (count(td_api_top_bar_template::get_all()) > 0) { ?>
        <!-- Top bar template -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">طرح بندی نوار بالا</span>
                <p>نحوه سفارش اقلام نوار بالا</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_top_bar_template',
                    'values' => td_api_top_bar_template::_helper_to_panel_values()
                ));
                ?>
            </div>
        </div>
    <?php } ?>


    <div class="td-box-section-separator"></div>


    <!-- Top menu: enable disable -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش منوی بالا</span>
            <p>منوی بالا را پنهان یا نمایش دهید. برای پنهان کردن نمادهای اجتماعی: سربرگ ⇢ شبکه های اجتماعی</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_top_menu',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>


    <!-- Top menu: select menu -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">منوی بالا را انتخاب کنید</span>
            <p>یک منو برای بخش بالایی انتخاب کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'wp_theme_menu_spot',
                'option_id' => 'top-menu',
                'values' => td_panel_generator::get_user_created_menus()
            ));
            ?>
        </div>
    </div>


    <div class="td-box-section-separator"></div>


    <!-- Social networks: enable disable -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش نمادهای اجتماعی</span>
            <p>شبکه های اجتماعی را در منوی بالا فعال / غیرفعال کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'td_social_networks_show',
                'true_value' => 'show',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>


    <div class="td-box-section-separator"></div>


    <!-- Date: enable disable -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش تاریخ</span>
            <p>پنهان کردن یا نمایش تاریخ در منوی بالا</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_data_top_menu',
                'true_value' => 'show',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>


    <!-- Date: format -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">فرمت تاریخ</span>
            <p>مقدار پیش‌فرض: l, F j, Y. <a href="http://php.net/manual/en/function.date.php">بیشتر بخوانید</a> درباره
                فرمت تاریخ (با تابع تاریخ php یکسان است)</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_data_time_format'
            ));
            ?>
        </div>
    </div>

    <!-- Date: format -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">تاریخ جاوااسکریپت</span>
            <p>اگر از افزونه کش استفاده می کنید، این را فعال کنید، داده های محلی را نمایش می دهد.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_data_js',
                'true_value' => 'true',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>


    <div class="td-box-section-separator td-box-weather"></div>
    <!-- Weather: enable disable -->
    <div class="td-box-row td-box-weather">
        <div class="td-box-description">
            <span class="td-box-title">نمایش آب و هوا</span>
            <p>اطلاعات آب و هوا را در منوی بالا پنهان یا نمایش دهید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_weather_top_menu',
                'true_value' => 'show',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>

    <!-- Weather: api key -->
    <div class="td-box-row td-box-weather">
        <div class="td-box-description">
            <span class="td-box-title">کلید Api</span>
            <p><a href="https://forum.tagdiv.com/weather-widget/" target="_blank">نحوه دریافت کلید api</a></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_weather_key_top_menu'
            ));
            ?>
        </div>
    </div>

    <!-- Weather: location -->
    <div class="td-box-row td-box-weather">
        <div class="td-box-description">
            <span class="td-box-title">مکان</span>
            <p><a href="http://openweathermap.org/find" target="_blank">موقعیت مکانی خود را پیدا کنید</a> - می توانید از "نام شهر" استفاده کنید
                یا "شناسه شهر" (آموزش ویجت آب و هوا را بررسی کنید).</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_weather_location_top_menu'
            ));
            ?>
        </div>
    </div>


    <!-- Weather: Units -->
    <div class="td-box-row td-box-weather">
        <div class="td-box-description">
            <span class="td-box-title">واحدها</span>
            <p>انتخاب کنید از چه واحدهایی هنگام نمایش دما استفاده شود</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_weather_units_top_menu',
                'values' => array(
                    array('text' => 'درجه سانتیگراد', 'val' => ''),
                    array('text' => 'فارنهایت', 'val' => 'imperial')
                )
            ));
            ?>
        </div>
    </div>


<?php echo td_panel_generator::box_end();
} ?>


<!-- MAIN MENU -->
<?php echo td_panel_generator::box_start('منو اصلی', false, 'tdb-hide'); ?>

<!-- MAIN MENU -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">منوی سرصفحه (اصلی)</span>
        <p>یک منو برای بخش سرصفحه اصلی انتخاب کنید</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::dropdown(array(
            'ds' => 'wp_theme_menu_spot',
            'option_id' => 'header-menu',
            'values' => td_panel_generator::get_user_created_menus()
        ));
        ?>
    </div>
</div>

<?php if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) { ?>
    <!-- Mega menu preload -->
    <div class="td-box-row td-box-megamenu-preloader">
        <div class="td-box-description">
            <span class="td-box-title">پیش بارگیری کننده مگا منو</span>
            <p>محتوا را برای همه منوهای بزرگ بارگیری کنید. این یک تجربه کاربری بهتر اما با عملکرد بهتر را ارائه می دهد
                - <a href="http://forum.tagdiv.com/what-is-ajax-preloading/" target="_blank">بیشتر بخوانید</a></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_mega_menu_ajax_preloading',
                'values' => array(
                    array('text' => '<strong>بدون پیش بارگذاری</strong> - default', 'val' => ''),
                    array('text' => '<strong>پیش بارگذاری بهینه شده</strong>', 'val' => 'preload'),
                    array('text' => '<strong>از پیش بارگیری همه </strong>', 'val' => 'preload_all')
                )
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator"></div>

    <!-- STICKY MENU -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">منوی چسبنده</span>
            <p>نحوه نمایش منوی سرصفحه در اسکرول</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_snap_menu',
                'values' => array(
                    array('text' => '<strong>منوی معمولی</strong> - (بدون چسبنده)', 'val' => ''),
                    array('text' => '<strong>همیشه چسبنده</strong> - در بالای صفحه می ماند', 'val' => 'snap'),
                    array('text' => '<strong>ضربه محکم و ناگهانی </strong> - (موبایل)', 'val' => 'smart_snap_mobile'),
                    array('text' => '<strong>ضربه محکم و ناگهانی</strong> - (همیشه)', 'val' => 'smart_snap_always'),
                )
            ));
            ?>
        </div>
    </div>

    <!-- SHOW THE MOBILE LOGO ON THE STICKY MENU -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگو در منوی چسبنده</span>
            <p>نمایش / پنهان کردن نشان‌واره در منوی چسبنده</p>
            <p><strong>توجه: </strong>اگر <strong>لوگوی تلفن همراه</strong> را انتخاب کردید، یک نشان‌واره را در <strong>لوگو آپلود کنید
                    بخش موبایل</strong></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_on_sticky',
                'values' => array(
                    array('text' => '<strong>غیرفعال</strong>', 'val' => ''),
                    array('text' => '<strong>لوگوی سربرگ</strong> - نشان‌واره سربرگ را نشان دهید', 'val' => 'show_header_logo'),
                    array('text' => '<strong>لوگوی تلفن همراه</strong> - نشان‌واره تلفن همراه را نشان دهید', 'val' => 'show'),
                )
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator"></div>

    <?php if ('Newspaper' == TD_THEME_NAME) { ?>
        <!-- Social networks: enable disable -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">نمایش نمادهای اجتماعی</span>
                <p>شبکه های اجتماعی را در منوی اصلی فعال / غیرفعال کنید</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::checkbox(array(
                    'ds' => 'td_option',
                    'option_id' => 'td_social_networks_menu_show',
                    'true_value' => 'show',
                    'false_value' => ''
                ));
                ?>
            </div>
        </div>
<?php }
} ?>

<?php echo td_panel_generator::box_end(); ?>


<!-- LOGO -->
<?php echo td_panel_generator::box_start('لوگو و فاویکون', false); ?>

<!-- LOGO UPLOAD -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">آپلود لوگو</span>
        <p>لوگوی خود را (272 × 90 پیکسل) png. یا jpg. آپلود کنید</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_logo_upload'
        ));
        ?>
    </div>
</div>

<div class="td-box-row" style="display:none;">
    <div class="td-box-description">
        <span class="td-box-title">عرض</span>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::input(array(
            'ds' => 'td_option',
            'option_id' => 'tds_logo_upload_width'
        ));
        ?>
    </div>
</div>

<div class="td-box-row" style="display:none;">
    <div class="td-box-description">
        <span class="td-box-title">طول</span>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::input(array(
            'ds' => 'td_option',
            'option_id' => 'tds_logo_upload_height'
        ));
        ?>
    </div>
</div>

<!-- RETINA LOGO UPLOAD -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">آپلود لوگو رتینا</span>
        <p>لوگو رتینا خود (544 x 180px) .png یا .jpg را آپلود کنید. </p>
        <ul>
            <li>اگر لوگو رتینا را تنظیم نکنید، سایت لوگوی معمولی را روی نمایشگرهای شبکیه بارگذاری می کند</li>
            <li>لوگو باید همان فرمت فایل را با آرم معمولی داشته باشد</li>
        </ul>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_logo_upload_r'
        ));
        ?>
    </div>
</div>


<!-- FAVICON -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">فاوآیکون</span>
        <p>اختیاری - آپلود تصویر فاویکون <br>(16 x 16 پیکسل) .png</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_favicon_upload'
        ));
        ?>
    </div>
</div>


<!-- Logo ALT attribute -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">لوگو ALT ویژگی</span>
        <p><a href="http://www.w3schools.com/tags/att_img_alt.asp" target="_blank">ویژگی Alt</a> برای لوگو. اگر نشان‌واره نمایش داده نشود، این متن جایگزین است. این برای سئو مفید است و به طور کلی نام سایت است.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::input(array(
            'ds' => 'td_option',
            'option_id' => 'tds_logo_alt'
        ));
        ?>
    </div>
</div>


<!-- Logo TITLE attribute -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">ویژگی عنوان لوگو</span>
        <p><a href="http://www.w3schools.com/tags/att_global_title.asp" target="_blank">ویژگی عنوان</a> برای لوگو. این ویژگی اطلاعات اضافی در مورد لوگو را مشخص می کند. اکثر مرورگرها یک راهنمای ابزار را با این متن در نشانگر نشان می دهند.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::input(array(
            'ds' => 'td_option',
            'option_id' => 'tds_logo_title'
        ));
        ?>
    </div>
</div>

<?php if (td_api_features::is_enabled('text_logo') === true) { ?>

    <!-- Text header LOGO description -->
    <div class="td-box-row" style="margin-top: 85px;">
        <div class="td-box-description td-box-full">
            <span class="td-box-title"><?php echo td_api_text::get('text_header_logo') ?></span>
            <p><?php echo td_api_text::get('text_header_logo_description') ?></p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>


    <!-- Text LOGO -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگوی متن</span>
            <p>یک لوگوی متنی بنویسید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_text',
                'placeholder' => strtoupper(TD_THEME_NAME)
            ));
            ?>
        </div>
    </div>


    <!-- Text LOGO Tagline -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">TAGLINE لوگوی متنی</span>
            <p>یک شعار برای لوگوی متن بنویسید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_tagline_text',
                'placeholder' => 'هنر انتشار را کشف کنید'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگوی H1 در صفحات </span>
            <p>فعال/غیرفعال کردن تگ H1 روی کد کوتاه لوگو در همه صفحات به جز صفحه اول. اگر غیرفعال باشد، تگ h1 صرف نظر از اینکه چه تنظیماتی در کد کوتاه Header Logo باشد، حذف خواهد شد.</p>
            <p>در صفحه اول، می توان آن را از کد کوتاه لوگو هدر غیرفعال کرد.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_h1_pages',
                'true_value' => '',
                'false_value' => 'false'
            ));
            ?>
        </div>
    </div>

<?php } ?>

<?php echo td_panel_generator::box_end(); ?>


<!-- LOGO for MOBILE-->
<?php
echo td_panel_generator::box_start('هدر موبایل', false);

if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) { ?>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <p>می توانید به صورت اختیاری یک لوگوی متفاوت را روی تلفن های همراه و صفحه نمایش های کوچک بارگذاری کنید. معمولا لوگو کوچکتر است
                به طوری که در منوی ضمیمه هوشمند قرار بگیرد. آیفون، آیپد، سامسونگ و بسیاری از گوشی ها از شبکیه چشم استفاده می کنند
                لوگو.</p>
            <p>اگر به طور پیش‌فرض لوگو موبایل آپلود نکنید، از لوگویی که در بخش آپلود کرده‌اید استفاده می‌شود
                در بالا. این گزینه زمانی توصیه می‌شود که لوگوی شما در دستگاه‌های تلفن همراه کامل نباشد.</p>
            <p><strong>توجه: </strong>اگر از آن استفاده می کنید، برای موبایل لوگو آپلود نکنید <strong>استایل هدر: </strong> <?php echo td_api_text::get('text_header_logo_mobile') ?>, لازم نیست.</p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <!-- LOGO MOBILE -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگو موبایل</span>
            <p>لوگوی خود را آپلود کنید</p>
            <p><strong>توجه: </strong>برای بهترین نتایج آرم موبایل
                اندازه: <?php echo td_api_text::get('text_header_logo_mobile_image') ?></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::upload_image(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_menu_upload'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row" style="display:none;">
        <div class="td-box-description">
            <span class="td-box-title">عرض</span>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_menu_upload_width'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row" style="display:none;">
        <div class="td-box-description">
            <span class="td-box-title">طول</span>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_menu_upload_height'
            ));
            ?>
        </div>
    </div>

    <!-- RETINA LOGO MOBILE IN MENU UPLOAD -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگو رتینا موبایل</span>
            <p>لوگوی شبکیه چشم خود را بارگذاری کنید (دو اندازه)</p>
            <p><strong>توجه: </strong>برای بهترین نتایج، لوگو رتینا موبایل
                اندازه: <?php echo td_api_text::get('text_header_logo_mobile_image_retina') ?></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::upload_image(array(
                'ds' => 'td_option',
                'option_id' => 'tds_logo_menu_upload_r'
            ));
            ?>
        </div>
        <div class="td-box-section-separator"></div>

    </div>

<?php } ?>



<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش منوی موبایل</span>
        <p>اگر غیرفعال باشد، HTML منوی موبایل (و دکمه روی هدرهای استاندارد) را حذف می کند.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_hide_mobile_menu',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش جستجوی موبایل</span>
        <p>اگر غیرفعال باشد، HTML جستجوی موبایل (و دکمه روی هدرهای استاندارد) را حذف می کند.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_hide_mobile_search',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<!-- more info -->
<div class="td-box-row">
    <div class="td-box-description td-box-full">
        <span class="td-box-title">اطلاعات بیشتر:</span>
        <p style="margin-bottom: 10px !important;">غیرفعال کردن این گزینه‌ها روی منوی موبایل و کدهای کوتاه جستجوی موبایل نیز تأثیر می‌گذارد. اگر ترجیح می دهید از قابلیت های جستجو و منوی موبایل استفاده نکنید، از این تنظیمات استفاده کنید.</p>
    </div>
</div>



<?php
echo td_panel_generator::box_end();
?>


<!-- SIGNIN/JOIN-->
<?php echo td_panel_generator::box_start('ورود / عضویت', false); ?>

<!-- Sign In / Join: enable disable -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش ورود / عضویت</span>
        <p>فعال/غیرفعال کردن ورود به هدر تم. (پیش فرض غیرفعال است).
            <?php td_util::tooltip_html('
                        <h3>نمایش ورود / عضویت:</h3>
                        <ul>
                            <li>این تنظیم برای قالب‌های سرصفحه از پیش تعریف‌شده تم اعمال می‌شود. </li>
                            <li>اگر فعال باشد، پیوند ورود به سیستم / عضویت در منوی بالا و منوی تلفن همراه نشان داده می شود.</li>
                        </ul>
                ', 'right') ?>
        </p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_login_sign_in_widget',
            'true_value' => 'show',
            'false_value' => ''
        ));
        ?>
    </div>
</div>

<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">تایید ایمیل در ثبت نام</span>
        <p>فعال/غیرفعال کردن تأیید ایمیل در ثبت نام (پیش‌فرض فعال است).
            <?php td_util::tooltip_html('
                        <p>با فعال کردن این گزینه آدرس ایمیل در هنگام ثبت نام با استفاده از تایید می شود is_email() function. <a href="https://developer.wordpress.org/reference/functions/is_email/" target="_blank">اطلاعات بیشتر!</a> </p>
                ', 'right') ?>
        </p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_verify_email_registration',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end(); ?>


<?php
if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) {
    if ('Newspaper' == TD_THEME_NAME) { ?>

        <!-- HEADER BACKGROUND -->
        <?php echo td_panel_generator::box_start('بک گراند سربرگ', false, 'tdb-hide'); ?>

        <!-- BACKGROUND UPLOAD -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">بک گراند سربرگ</span>
                <p>یک تصویر پس زمینه هدر را آپلود کنید</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::upload_image(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_header_background_image'
                ));
                ?>
            </div>
        </div>

        <!-- Background Repeat -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">تکرار</span>
                <p>نحوه نمایش تصویر پس زمینه</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::radio_button_control(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_header_background_repeat',
                    'values' => array(
                        array('text' => 'No Repeat', 'val' => ''),
                        array('text' => 'Tile', 'val' => 'repeat'),
                        array('text' => 'Tile Horizontally', 'val' => 'repeat-x'),
                        array('text' => 'Tile Vertically', 'val' => 'repeat-y')
                    )
                ));
                ?>
            </div>
        </div>

        <!-- Background Size -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">SIZE</span>
                <p>Set the background image size</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::radio_button_control(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_header_background_size',
                    'values' => array(
                        array('text' => 'Auto', 'val' => 'auto'),
                        array('text' => 'Full Width', 'val' => '100% auto'),
                        array('text' => 'Full Height', 'val' => 'auto 100%'),
                        array('text' => 'Cover', 'val' => ''),
                        array('text' => 'Contain', 'val' => 'contain')
                    )
                ));
                ?>
            </div>
        </div>

        <!-- Background position -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">POSITION</span>
                <p>Position your background image</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::radio_button_control(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_header_background_position',
                    'values' => array(
                        array('text' => 'Bottom', 'val' => ''),
                        array('text' => 'Center', 'val' => 'center center'),
                        array('text' => 'Top', 'val' => 'center top')
                    )
                ));
                ?>
            </div>
        </div>

        <!-- Background opacity -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">BACKGROUND OPACITY</span>
                <p>Set the background image transparency (Example: 0.3)</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::input(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_header_background_opacity'
                ));
                ?>
            </div>
        </div>

        <?php echo td_panel_generator::box_end(); ?>
<?php }
} ?>


<!-- iOS Bookmarklet -->
<?php echo td_panel_generator::box_start('iOS بوک مارکلت', false); ?>

<div class="td-box-row">
    <div class="td-box-description td-box-full">
        <p> نشانک‌ها در iOS و Android کار می‌کنند. وقتی کاربر سایت شما را به صفحه اصلی اضافه می کند، تلفن یکی از نمادها را از اینجا دانلود می کند (بر اساس اندازه صفحه و نوع دستگاه) و سایت شما با آن نماد در صفحه اصلی ظاهر می شود</p>
    </div>
    <div class="td-box-row-margin-bottom"></div>
</div>



<!-- iOS bookmarklet 76x76 -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">عکس 76 x 76</span>
        <p>آیکون خود را آپلود کنید (76 x 76px) .png</p>
    </div>
    <div class="td-box-control-full">
        <?php // ipad mini non retina + ipad 2
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_ios_icon_76'
        ));
        ?>
    </div>
</div>


<!-- iOS bookmarklet 114x114 -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">عکش 114 x 114</span>
        <p>آیکون خود را آپلود کنید (114 x 114px) .png</p>
    </div>
    <div class="td-box-control-full">
        <?php  // iphone retina ios6
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_ios_icon_114'
        ));
        ?>
    </div>
</div>


<!-- iOS bookmarklet 120x120 -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">عکس 120 x 120</span>
        <p>آیکون خود را آپلود کنید (120 x 120px) .png</p>
    </div>
    <div class="td-box-control-full">
        <?php // iphone retina ioS7
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_ios_icon_120'
        ));
        ?>
    </div>
</div>


<!-- iOS bookmarklet 144x144 -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">عکس 144 x 144</span>
        <p>آیکون خود را آپلود کنید ( 144 x 144px) .png</p>
    </div>
    <div class="td-box-control-full">
        <?php // ipad retina ios6
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_ios_icon_144'
        ));
        ?>
    </div>
</div>


<!-- iOS bookmarklet 152x152 -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">عکس 152 x 152</span>
        <p>آیکون خود را آپلود کنید (152 x 152px) .png</p>
    </div>
    <div class="td-box-control-full">
        <?php // ipad retina ios7
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_ios_icon_152'
        ));
        ?>
    </div>
</div>


<?php echo td_panel_generator::box_end(); ?>