<!-- FOOTER SETTINGS -->
<?php

$tdb_footer_template_is_set = false;

if (td_global::is_tdb_registered()) {

    $tdb_footer_templates = array();

    // read the tdb category templates
    $wp_query_templates = new WP_Query(
        array(
            'post_type' => 'tdb_templates',
            'posts_per_page' => -1
        )
    );

    if (!empty($wp_query_templates->posts)) {

        foreach ($wp_query_templates->posts as $post) {

            $tdb_template_type = get_post_meta($post->ID, 'tdb_template_type', true);

            if ($tdb_template_type === 'footer') {
                $tdb_footer_templates[] = array(
                    'text' => $post->post_title,
                    'val' => 'tdb_template_' . $post->ID
                );
            }

            $tdb_footer_template = td_options::get('tdb_footer_template');

            if ($tdb_template_type === 'footer' && $tdb_footer_template === 'tdb_template_' . $post->ID) {
                $tdb_footer_template_is_set = true;
            }
        }
    }


?>

    <!-- Cloud Library Footer template -->
    <?php echo td_panel_generator::box_start(); ?>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">الگوی کتابخانه ابری</span>
            <p>یک <a href="<?php echo admin_url('admin.php?page=tdb_cloud_templates') ?>" target="_blank">الگوی پاورقی Cloud Library</a> برای همه وب سایت ها.</p>
        </div>
        <div class="td-box-control-full">

            <?php

            $option_id = 'tdb_footer_template';
            if (class_exists('SitePress', false)) {
                global $sitepress;
                $sitepress_settings = $sitepress->get_settings();
                if (isset($sitepress_settings['custom_posts_sync_option']['tdb_templates'])) {
                    $translation_mode = (int) $sitepress_settings['custom_posts_sync_option']['tdb_templates'];
                    if (1 === $translation_mode) {
                        $option_id .= $sitepress->get_current_language();
                    }
                }
            }

            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => $option_id,
                'values' => array_merge(
                    array(
                        array('text' => '- No Template -', 'val' => ''),
                    ),
                    $tdb_footer_templates
                )
            ));

            ?>

        </div>
    </div>
    <div class="td-box-section-separator"></div>

    <!-- more info -->
    <div class="td-box-row">
        <div class="td-box-description" style="float: none !important; width: auto !important; padding-bottom: 0 !important;">
            <span class="td-box-title">اطلاعات بیشتر:</span>
            <p style="margin-bottom: 10px !important;">فعال کردن این گزینه بارگیری الگوی ابر پاورقی را در پست‌ها و صفحات به تأخیر می‌اندازد و اگر پاورقی در بارگذاری صفحه اولیه در نمای نمایش یافت شود، بارگیری می‌شود، در غیر این صورت در اولین تعامل کاربر، مانند اسکرول، حرکت موز و غیره بارگیری می‌شود. <a href="#" class="td-tooltip" style="margin-left: 5px;" data-position="right" data-content-as-html="true" title="<?php echo esc_attr('<p>Please note that the <strong>FOOTER DELAYED LOAD</strong> option works only for Cloud Library Footer templates and for footer cloud templates with complex content may break javascript functionality of some theme or external plugins features which may lead to unexpected behaviours.</p>') ?>">توجه</a></p>
            <p>این برای بهینه سازی سرعت صفحه مفید است، مانند اجتناب از اندازه DOM بیش از حد. <a href="https://developer.chrome.com/en/docs/lighthouse/performance/dom-size/" target="_blank">مشاهده بیشتر</a></p>
        </div>
        <div class="td-box-section-separator" style="margin-top: 30px;"></div>
    </div>

    <!-- Enable footer delayed load -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">بارگیری تنبل پاورقی</span>
            <p>بارگذاری تاخیری را برای محتوای الگوی ابر پاورقی روشن/خاموش کنید.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_ui_delay',
                'true_value' => 'on',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>

    <?php echo td_panel_generator::box_end(); ?>

    <hr>

<?php } ?>

<?php if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) {
    echo td_panel_generator::box_start('تنظیمات فوتر', true, 'tdb-hide');
?>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <span class="td-box-title">اطلاعات بیشتر:</span>
            <p> پاورقی از نوارهای کناری برای نمایش اطلاعات استفاده می کند. در اینجا می‌توانید تعداد ستون‌های کناری و طرح‌بندی را سفارشی کنید. برای افزودن محتوا به قسمت پایین صفحه، به بخش ابزارک ها بروید و ویجت را به نوارهای کناری پاورقی 1، پاورقی 2 و پاورقی 3 بکشید.</p>
            <p>برخی از الگوهای پاورقی حاوی محتوای از پیش تعریف شده هستند، مانند <strong>محتوای اطلاعات</strong> و می‌توانند از بخش <strong>محتوای اطلاعات پاورقی</strong> تنظیم شوند.</p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <!-- Enable footer -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش پاورقی</span>
            <p>نمایش یا پنهان کردن پاورقی</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer',
                'true_value' => '',
                'false_value' => 'no'
            ));
            ?>
        </div>
    </div>

    <!-- LAYOUT -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">الگوهای پاورقی</span>
            <p>قالب پاورقی را تنظیم کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_template',
                'values' => td_api_footer_template::_helper_to_panel_values()
            ));
            ?>
        </div>
    </div>

<?php } ?>

<!-- PAGE FOOTER -->
<?php if ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK')) { ?>
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">صفحه پاورقی</span>
            <p>صفحه پاورقی را تنظیم کنید</p>
        </div>
        <div class="td-box-control-full td-footer-page-container">
            <?php

            $page_values = array();

            $pages = get_pages(array());
            foreach ($pages as $page) {

                $text = $page->post_title;
                if (empty($text)) {
                    $text = '#' . $page->ID . '(no title)';
                }

                $page_values[] = array(
                    'text' => $text,
                    'val' => $page->ID
                );
            }

            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_page',
                'values' => array_merge(
                    array(
                        array('text' => '- بدون صفحه -', 'val' => ''),
                    ),
                    $page_values
                )
            ));

            $href = '#';
            $style = 'display: none';

            $tds_footer_page = td_util::get_option('tds_footer_page');

            if ('' !== $tds_footer_page && 'publish' === get_post_status(intval($tds_footer_page))) {
                $href = admin_url() . 'post.php?post_id=' . td_util::get_option('tds_footer_page') . '&td_action=tdc&tdbTemplateType=page';
                $style = '';
            }

            echo '<a class="td-view-footer-page" href="' . $href . '" style="' . $style . '" target="_blank">ویرایش صفحه هدر</a>';

            ?>
        </div>
    </div>
<?php } ?>

<?php
if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) {
    echo td_panel_generator::box_end();
}
?>


<!-- FOOTER INSTAGRAM SETTINGS -->
<?php if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) {
    echo td_panel_generator::box_start('تنظیمات اینستاگرام', false, 'tdb-hide'); ?>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <p>از این بخش می توانید <strong>بخش پاورقی اینستاگرام</strong> - این ناحیه را تنظیم و پیکربندی کنید
                در بالای بخش پاورقی در همه صفحات ظاهر می شود</p>
            <ul>
                <li> توجه: هنگامی که این را فعال می کنید، لطفاً مطمئن شوید که یک را متصل کرده اید<a href="<?php echo admin_url('admin.php?page=td_theme_panel#td-panel-social-networks/box=instagram_business') ?>" target="_blank">صفحه اکانت تجاری اینستاگرام</a> و همچنین شناسه صفحه اکانت بیزینس اینستاگرام را در قسمت <strong>آی دی بیزینس اینستاگرام</strong> وارد کنید!</li>
            </ul>
        </div>


        <div class="td-box-row-margin-bottom"></div>
    </div>

    <!-- Enable Instagram -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش بخش اینستاگرام پاورقی</span>
            <p>نمایش یا پنهان کردن بخش اینستاگرام</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_instagram',
                'true_value' => 'show',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>

    <!-- Instagram Business Page ID -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">ID کسب و کار اینستاگرام</span>
            <p>شناسه صفحه (حساب) کسب و کار را همانطور که بعد از نشانی اینترنتی اینستاگرام ظاهر می‌شود وارد کنید (مثلاً instagram.com/<strong>myID</strong> )</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_instagram_id'
            ));
            ?>
        </div>
    </div>

    <?php if (TD_DEPLOY_MODE === 'dev' || TD_DEPLOY_MODE === 'demo') { ?>
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">شناسه‌های نمایشی اینستاگرام</span>
                <p>داده هایی را که با کاما از هم جدا شده اند به این ترتیب وارد کنید (آواتار، شماره دنبال کنندگان، شناسه تصاویر)</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::textarea(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_footer_instagram_data'
                ));
                ?>
            </div>
        </div>
    <?php } ?>
    <!-- number of images per row -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">تعداد تصاویر در هر ردیف:</span>
            <p>تعداد تصاویر نمایش داده شده در هر ردیف را تنظیم کنید (پیش فرض 3 است)</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_instagram_on_row_images_number',
                'values' => array(
                    array('text' => '- پیش فرض -', 'val' => ''),
                    array('text' => '1', 'val' => 1),
                    array('text' => '2', 'val' => 2),
                    array('text' => '3', 'val' => 3),
                    array('text' => '4', 'val' => 4),
                    array('text' => '5', 'val' => 5),
                    array('text' => '6', 'val' => 6),
                    array('text' => '7', 'val' => 7),
                    array('text' => '8', 'val' => 8),
                )
            ));
            ?>
        </div>
    </div>

    <!-- number of rows -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">تعداد ردیف:</span>
            <p>تنظیم تعداد ردیف برای نمایش تصاویر (پیش فرض 1 است)</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_instagram_rows_number',
                'values' => array(
                    array('text' => '- پیش فرض -', 'val' => ''),
                    array('text' => '1', 'val' => 1),
                    array('text' => '2', 'val' => 2),
                    array('text' => '3', 'val' => 3),
                    array('text' => '4', 'val' => 4),
                    array('text' => '5', 'val' => 5)
                )
            ));
            ?>
        </div>
    </div>

    <!-- size of images -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">اندازه تصویر:</span>
            <p>اندازه تصاویر را تنظیم کنید (به طور پیش فرض از اندازه کامل تصویر استفاده می شود)</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_instagram_image_size',
                'values' => array(
                    array('text' => '- پیش فرض - کامل -', 'val' => ''),
                    array('text' => 'کوچک - 150px', 'val' => 'td_150x0'),
                    array('text' => 'کوچک - 300px', 'val' => 'td_300x0'),
                    array('text' => 'مدیوم - 696px', 'val' => 'td_696x0'),
                    array('text' => 'بزرگ - 1068px', 'val' => 'td_1068x0')
                )
            ));
            ?>
        </div>
    </div>

    <!-- image gap -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">شکاف تصویر</span>
            <p>یک فاصله بین تصاویر تنظیم کنید (پیش‌فرض: بدون فاصله)</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_instagram_image_gap',
                'values' => array(
                    array('text' => 'بدون گپ', 'val' => ''),
                    array('text' => '2 px', 'val' => 2),
                    array('text' => '5 px', 'val' => 5)
                )
            ));
            ?>
        </div>
    </div>


    <?php echo td_panel_generator::box_end(); ?>


    <!-- FOOTER PREDEFINED CONTENT -->
    <?php echo td_panel_generator::box_start('محتوای اطلاعات پاورقی', false, 'tdb-hide'); ?>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <ul>
                <li>لوگوی پاورقی - متفاوت از لوگوی سرصفحه. اگر لوگوی فوتر مشخص نشده باشد، سایت مشخص خواهد شد
                    لوگوی عادی پیش فرض را بارگیری کنید.
                </li>
                <li>متن پاورقی - معمولاً متنی درباره موضوع سایت شما است</li>
                <li>آدرس ایمیل تماس شما</li>
                <li>نمادهای اجتماعی - برای سفارشی کردن نمادهای اجتماعی در پاورقی، به <strong>اجتماعی بروید
                        بخش شبکه ها</strong>.
                </li>
            </ul>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <!-- logo -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگوی فوتر</span>
            <p>لوگوی خود را آپلود کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::upload_image(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_logo_upload'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row" style="display:none;">
        <div class="td-box-description">
            <span class="td-box-title">عرض</span>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_logo_upload_width'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row" style="display:none;">
        <div class="td-box-description">
            <span class="td-box-title">ارتفاع</span>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_logo_upload_height'
            ));
            ?>
        </div>
    </div>


    <!-- logo retina -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">لوگوی پاورقی شبکیه چشم</span>
            <p>آرم شبکیه چشم خود را (دو اندازه) آپلود کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::upload_image(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_retina_logo_upload'
            ));
            ?>
        </div>
    </div>

    <!-- footer logo alt -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">LOGO ALT ATTRIBUTE</span>
            <p><a target="_blank" href="http://www.w3schools.com/tags/att_img_alt.asp">ویژگی Alt</a> برای نشان‌واره.
                اگر نشان‌واره نمایش داده نشود، این متن جایگزین است. برای سئو مفید است و به طور کلی مفید است
                نام سایت
                <?php td_util::tooltip_html('
<h3>لوگوی پاورقی ALT:</h3>
 <p>اگر ویژگی alt فوتر را تنظیم نکنید، طرح زمینه از یک مجموعه برای نشان‌واره سرصفحه استفاده می‌کند.</p>

                ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_logo_alt'
            ));
            ?>
        </div>
    </div>

    <!-- footer logo title -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">ویژگی عنوان لوگو</span>
            <p><a target="_blank" href="http://www.w3schools.com/tags/att_global_title.asp">ویژگی عنوان</a> برای
                لوگو این ویژگی اطلاعات اضافی در مورد لوگو را مشخص می کند. اکثر مرورگرها یک راهنمای ابزار را نشان می دهند
                این متن روی لوگو شناور است.
                <?php td_util::tooltip_html('
<h3> عنوان لوگوی پاورقی:</h3>
 <p>اگر ویژگی عنوان پاورقی را تنظیم نکنید، طرح زمینه از یک مجموعه برای نشان‌واره سرصفحه استفاده می‌کند.</p>

                ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_logo_title'
            ));
            ?>
        </div>
    </div>

    <!-- footer text -->
    <div class="td-box-row td-custom-css">
        <div class="td-box-description">
            <span class="td-box-title">متن فوتر</span>
            <p>
                متن پاورقی خود را اینجا بنویسید
                <?php td_util::tooltip_html('
<h3>تنظیم متن حق نشر پاورقی:</h3>
 <p>می توانید از یکی از میانبرهای زیر در این متن استفاده کنید:</p>
                        <ul>
                            <li>##copy## - &copy;</li>
                            <li>##privacy_policy## - ' . td_util::get_the_privacy_policy_link() . '</li>
                            <li>##year## - ' . date('Y') . '</li>
                            <li>##sitename## - ' . get_bloginfo('name') . '</li>
                            <li>##siteurl## - ' . get_home_url() . '</li>
                            <li>##sitelink## - ' . '<a href="' . get_home_url() . '">' . get_bloginfo('name') . '</a>' . '</li>
                        </ul>
                ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::textarea(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_text',
            ));
            ?>
        </div>
    </div>


    <!-- Footer contact email -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">آدرس ایمیل شما</span>
            <p>آدرس ایمیل شما</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_email'
            ));
            ?>
        </div>
    </div>


    <!-- Enable social icons -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش نمادهای اجتماعی</span>
            <p>نمایش یا پنهان کردن نمادهای اجتماعی، برای تنظیم نمادهای اجتماعی به <strong>شبکه های اجتماعی</strong></p> بروید
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_social',
                'true_value' => '',
                'false_value' => 'no'
            ));
            ?>
        </div>
    </div>
    <?php echo td_panel_generator::box_end(); ?>


    <!-- FOOTER BACKGROUND -->
    <?php echo td_panel_generator::box_start('پس زمینه فوتر', false, 'tdb-hide'); ?>

    <!-- BACKGROUND UPLOAD -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">پس‌زمینه فوتر</span>
            <p>یک تصویر پس زمینه پاورقی را آپلود کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::upload_image(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_background_image'
            ));
            ?>
        </div>
    </div>

    <!-- Background Repeat -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">تکرار</span>
            <p>نحوه نمایش تصویر پس زمینه</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_background_repeat',
                'values' => array(
                    array('text' => 'بدون تکرار', 'val' => ''),
                    array('text' => 'عنوان', 'val' => 'repeat'),
                    array('text' => 'کاشی به صورت افقی', 'val' => 'repeat-x'),
                    array('text' => 'کاشی به صورت عمودی', 'val' => 'repeat-y')
                )
            ));
            ?>
        </div>
    </div>

    <!-- Background Size -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">سایز</span>
            <p>اندازه تصویر پس زمینه را تنظیم کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_background_size',
                'values' => array(
                    array('text' => 'خودکار', 'val' => ''),
                    array('text' => 'تمام عرض', 'val' => '100% auto'),
                    array('text' => 'تمام طول', 'val' => 'auto 100%'),
                    array('text' => 'کاور', 'val' => 'cover'),
                    array('text' => 'حاوی', 'val' => 'contain')
                )
            ));
            ?>
        </div>
    </div>

    <!-- Background position -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">موقعیت</span>
            <p>تصویر پس زمینه خود را در موقعیت قرار دهید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_background_position',
                'values' => array(
                    array('text' => 'پایین', 'val' => ''),
                    array('text' => 'مرکز', 'val' => 'center center'),
                    array('text' => 'بالا', 'val' => 'center top')
                )
            ));
            ?>
        </div>
    </div>

    <!-- Background opacity -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">مادر بودن پس زمینه</span>
            <p>شفافیت تصویر پس زمینه را تنظیم کنید (مثال: 0.3)</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::input(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_background_opacity'
            ));
            ?>
        </div>
    </div>

    <?php echo td_panel_generator::box_end(); ?>


    <!-- SUB-FOOTER SETTINGS -->
    <?php echo td_panel_generator::box_start('تنظیمات زیر پاورقی', false, 'tdb-hide'); ?>


    <!-- text -->
    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <span class="td-box-title">اطلاعات بیشتر:</span>
            <p>بخش زیر پاورقی محتوای زیر پاورقی اصلی است. معمولاً شامل یک متن حق چاپ و یک
                نقطه منو در سمت راست</p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <?php if ('Newsmag' == TD_THEME_NAME || ('Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK'))) { ?>
        <!-- Enable sub-footer -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">نمایش زیر پاورقی</span>
                <p>نمایش یا پنهان کردن پاورقی فرعی</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::checkbox(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_sub_footer',
                    'true_value' => '',
                    'false_value' => 'no'
                ));
                ?>
            </div>
        </div>

        <!-- LAYOUT -->
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">الگوهای پاورقی فرعی</span>
                <p>قالب پاورقی فرعی را تنظیم کنید</p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_sub_footer_template',
                    'values' => td_api_sub_footer_template::_helper_to_panel_values()
                ));
                ?>
            </div>
        </div>
    <?php } ?>

    <!-- Footer copyright text -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">متن حق نسخه برداری پاورقی</span>
            <p>
                Set footer copyright text
                <?php td_util::tooltip_html('
                        <h3>تنظیم متن حق نشر پاورقی:</h3>
 <p>می توانید از یکی از میانبرهای زیر در این متن استفاده کنید:</p>
                        <ul>
                            <li>##copy## - &copy;</li>
                            <li>##privacy_policy## - ' . td_util::get_the_privacy_policy_link() . '</li>
                            <li>##year## - ' . date('Y') . '</li>
                            <li>##sitename## - ' . get_bloginfo('name') . '</li>
                            <li>##siteurl## - ' . get_home_url() . '</li>
                            <li>##sitelink## - ' . '<a href="' . get_home_url() . '">' . get_bloginfo('name') . '</a>' . '</li>
                        </ul>
                ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::textarea(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_copyright'
            ));
            ?>
        </div>
    </div>


    <!-- Copyright symbol -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نماد حق نسخه برداری</span>
            <p>نمایش یا پنهان کردن نماد حق نشر پاورقی</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_footer_copy_symbol',
                'true_value' => '',
                'false_value' => 'no'
            ));
            ?>
        </div>
    </div>

    <!-- Footer menu -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">منو فوتر</span>
            <p>یک منو برای پاورقی فرعی انتخاب کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'wp_theme_menu_spot',
                'option_id' => 'footer-menu',
                'values' => td_panel_generator::get_user_created_menus()
            ));
            ?>
        </div>
    </div>
<?php echo td_panel_generator::box_end();
} ?>
