<!-- CATEGORY page -->
<?php echo td_panel_generator::box_start('دسته بندی تنظیمات جهانی', true);

$tdb_category_template_is_set = false;

if ( td_global::is_tdb_registered() ) {

    $tdb_category_template_type_values = array();

    // read the tdb category templates
    $wp_query_templates = new WP_Query( array(
            'post_type' => 'tdb_templates',
		    'posts_per_page' => -1
	    )
    );

    if ( !empty( $wp_query_templates->posts ) ) {

        foreach ( $wp_query_templates->posts as $post ) {

            $tdb_template_type = get_post_meta( $post->ID, 'tdb_template_type', true );
            $meta_is_mobile_template = get_post_meta($post->ID, 'tdc_is_mobile_template', true);

            if ( $tdb_template_type === 'category' && (empty($meta_is_mobile_template) || '0' === $meta_is_mobile_template)) {
                $tdb_category_template_type_values [] = array(
                    'text' => $post->post_title,
                    'val' => 'tdb_template_' . $post->ID
                );
            }

            $tdb_category_template = td_options::get( 'tdb_category_template' );

            if ( $tdb_template_type === 'category' && $tdb_category_template === 'tdb_template_' . $post->ID ) {
                $tdb_category_template_is_set = true;
            }
        }
    }

?>

<!-- Cloud Library Category template -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">الگوی کتابخانه ابری</span>
        <p>Set a <a href="<?php echo admin_url( 'admin.php?page=tdb_cloud_templates' ) ?>" target="_blank">الگوی دسته‌بندی Cloud Library</a> برای همه دسته‌ها.</p>
    </div>
    <div class="td-box-control-full">

        <?php

        $option_id = 'tdb_category_template';
        if (class_exists('SitePress', false )) {
            global $sitepress;
            $sitepress_settings = $sitepress->get_settings();
            if ( isset($sitepress_settings['custom_posts_sync_option'][ 'tdb_templates']) ) {
                $translation_mode = (int)$sitepress_settings['custom_posts_sync_option']['tdb_templates'];
                if (1 === $translation_mode) {
                    $option_id .= $sitepress->get_current_language();
                }
            }
        }

        echo td_panel_generator::dropdown(array(
            'ds' => 'td_option',
            'option_id' => $option_id,
            'values' => array_merge(
                array(
                    array('text' => '- No Template -' , 'val' => ''),
                ),
                $tdb_category_template_type_values
            )
        ));

        ?>

    </div>
</div>

<?php }

if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK') ) ) { ?>
    <div class="td-box-section-separator tdb-hide"></div>

    <div class="td-box-description td-box-full tdb-hide">
        <p>طرح پیش فرض را برای همه دسته ها تنظیم کنید. توجه داشته باشید که می‌توانید طرح‌بندی و تنظیمات هر دسته را از پانل تم ⇢ دسته‌ها تغییر دهید</p>
        <ul>
            <li>می‌توانید هر صفحه دسته‌بندی را با رفتن به پست‌ها ⇢ دسته‌ها ⇢ روی یک دسته نگه دارید ⇢ مشاهده را انتخاب کنید</li>
            <li>این قالب وردپرس در فایل <strong>category.php</strong> قرار دارد.</li>
        </ul>
    </div>

    <!-- Category template -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">قالب دسته</span>
            <p>
            این سرفصل دسته است
                <?php td_util::tooltip_html('
                        <h3>قالب دسته:</h3>
                        <p>از اینجا می توانید عنوان دسته را تغییر دهید.</p>
                        <ul>
                            <li>این تنظیم را می توان بر اساس هر دسته از کادرهای زیر بازنویسی کرد</li>
 <li>برخی از سرصفحه ها نیز شرح دسته را نشان می دهند</li>
 <li>برای کاربران حرفه ای که می خواهند سرصفحه دسته را سفارشی کنند، در اینجا آمده است <a target="_blank" href="http://forum.tagdiv.com/api-category-top-section-template-introduction/">API documentation</a></li>
                            <li>از پیدا کردن هدری که دوست دارید لذت ببرید!</li>
                        </ul>
                ', 'right')?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_category_template',
                'values' => td_api_category_template::_helper_to_panel_values()
            ));
            ?>
        </div>
    </div>

    <!-- Category pull-down filter -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">فیلتر کشویی دسته</span>
            <p>
            این تنظیم نمایش فیلتر کشویی دسته را کنترل می کند.
                <?php td_util::tooltip_html('
                        <h3>فیلتر کشویی دسته:</h3>
                        <p>این گزینه به شما امکان می دهد این فیلتر را فعال یا غیرفعال کنید:</p>
                        <ul>
                            <li>به طور پیش فرض فعال است.</li>
                            <li>این فیلتر به شما امکان می‌دهد تا ترتیب مرتب‌سازی پست متفاوتی را تنظیم کنید و می‌توانید آن را در قسمت بالای صفحه دسته‌بندی پیدا کنید.</li>
                            <li>اگر "غیرفعال کردن" را انتخاب کنید، این فیلتر از تمام صفحات دسته حذف می شود.</li>
                        </ul>
                ', 'right')?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_category_pull_down',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <!-- Category top posts style -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">سبک پست های برتر دسته</span>
            <p>
            سبک پست بالا را تنظیم کنید
                <?php td_util::tooltip_html('
                        <h3>سبک های پست برتر دسته:</h3>
                        <p>آخرین پست‌ها را در صفحه دسته‌بندی برجسته کنید</p>
                        <ul>
                            <li>این تنظیم را می توان بر اساس هر دسته از کادرهای زیر بازنویسی کرد</li>
                            <li>از این تنظیم + the استفاده کنید <i>سبک شبکه</i> تنظیم کنید تا به نتایجی که می خواهید برسید</li>
                            <li>برای کاربران پیشرفته، اینجاست <a target="_blank" href="http://forum.tagdiv.com/api-category-top-section-style-introduction/">اسناد API</a></li>
                        </ul>
                ', 'right')?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_category_top_posts_style',
                'values' => td_api_category_top_posts_style::_helper_to_panel_values()
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row tdb-hide">
            <div class="td-box-description">
                <span class="td-box-title">رده پست های برتر GRID STYLE</span>
                <p>هر شبکه دسته بندی از چندین سبک پشتیبانی می کند</p>
            </div>
            <div class="td-box-control-full">
                <?php

                $td_grid_style_values = array();
                foreach (td_global::$big_grid_styles_list as $big_grid_id => $params) {
                    $td_grid_style_values []= array(
                        'text' => $params['text'],
                        'val' => $big_grid_id
                    );
                }
                echo td_panel_generator::dropdown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_category_td_grid_style',
                    'values' => $td_grid_style_values
                ));
                ?>
            </div>
        </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <!-- DISPLAY VIEW -->
    <div class="td-box-row tdb-hide">
            <div class="td-box-description">
                <span class="td-box-title">نمای نمایش مقاله</span>
                <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود. <?php echo ('enabled' !== td_util::get_option('tds_white_label')) ? 'برای ماژول های سفارشی یا تنظیم، بخوانید <a target="_blank" href="http://forum.tagdiv.com/api-modules-introduction/">API ماژول</a>' : '' ?></p>
            </div>
            <div class="td-box-control-full td-panel-module">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_category_page_layout',
                    'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
                ));
                ?>
            </div>
        </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">سبک صفحه بندی</span>
            <p>یک سبک صفحه بندی برای همه دسته ها تنظیم کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_category_pagination_style',
                'values' => array(
                    array (
                        'val' => '',
                        'text' => 'صفحه بندی معمولی'
                    ),
                    array (
                        'val' => 'infinite',
                        'text' => 'بارگذاری بی نهایت'
                    ),
                    array (
                        'val' => 'infinite_load_more',
                        'text' => 'بارگذاری بی نهایت + بارگذاری بیشتر'
                    )
                )
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_category_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_category_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>


    <?php }
echo td_panel_generator::box_end();?>



<hr>
<div class="td-section-separator">تنظیمات هر دسته</div>



<?php


/**
 * custom walker - it's used only in this panel
 * Class td_category_walker_panel
 */
class td_category_walker_panel extends Walker {
    var $tree_type = 'category';
    var $db_fields = array ('parent' => 'parent', 'id' => 'term_id');


    var $td_category_hierarchy = array();  // we store them like so [0] Category 1 - [1] Category 2 - [2] Category 3


    var $td_category_buffer = array();

    /**
     * $td_last_depth - int.
     * store the last depth, used to reset $td_category_hierarchy on multiple branches
     * Ex:
     *      - main category[depth 0]:
     *                    - subcategory a [depth 1]
     *                         - subcategory a1 [depth 2]
     *                              - subcategory a12 [depth 3]
     *                    - subcategory b [depth 1]
     *                         - subcategory b1 [depth 2]
     *                              - subcategory b12 [depth 3]
     * they are processed in the same sequence
     * when you pass from depth 3 to 1 you have to remove the previous items present on depth 2 and 3 inside the $td_category_hierarchy array
     */
    var $td_last_depth = 0;

    function start_lvl( &$output, $depth = 0, $args = array() ) {

    }

    function end_lvl( &$output, $depth = 0, $args = array() ) {

    }


    function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {

        // reset the $td_category_hierarchy array
        if ($this->td_last_depth > $depth && $depth > 0) {
            $buffy = array();
            //keep only the array elements which have a depth lower than the current depth
            //the current element is added after this sequence, in the "build the category hierarchy" line
            for ($i = 0; $i < $depth; $i++){
                $buffy[] = $this->td_category_hierarchy[$i];
            }
            $this->td_category_hierarchy = $buffy;
        }
        $this->td_last_depth = $depth;

        //build the category hierarchy - [0] Category 1 - [1] Category 2 - [2] Category 3
        $this->td_category_hierarchy[$depth] = $category;

        if ($depth == 0) {
            //reset the parrents
            $this->td_category_hierarchy = array();
            //put the
            $this->td_category_hierarchy[0] = $category;

            //add first parent
            $this->td_category_buffer['<a href="' . get_category_link($category->term_id) . '" target="_blank" data-is-category-link="yes">' . $category->name . '</a>'] = $category->term_id;
        } else {

            $td_tmp_buffer = '';
            $last_cat_id = 0;
            $contor_array = 0;
            //print_r($this->td_category_hierarchy);
            foreach ($this->td_category_hierarchy as $parent_cat_obj) {

                if ($td_tmp_buffer === '') {
                    $td_tmp_buffer = '<a href="' . get_category_link($parent_cat_obj->term_id) . '" target="_blank" data-is-category-link="yes">' . $parent_cat_obj->name . '</a>';
                    $last_cat_id = $parent_cat_obj->term_id;
                } else {
                    if($this->td_category_hierarchy[$contor_array-1]->term_id == $parent_cat_obj->parent) {
                        $td_tmp_buffer .=  '<img src="' . TDC_URL_LEGACY_COMMON . '/wp_booster/wp-admin/images/panel/panel-breadcrumb.png" class="td-panel-breadcrumb"/>' . '<a href="' . get_category_link($parent_cat_obj->term_id) . '" target="_blank" data-is-category-link="yes">' . $parent_cat_obj->name . '</a>';
                        $last_cat_id = $parent_cat_obj->term_id;
                    }
                }

                $contor_array++;

            }


            //add child
            $this->td_category_buffer[$td_tmp_buffer] = $last_cat_id;

        }


    }


    function end_el( &$output, $page, $depth = 0, $args = array() ) {

    }

}


// get all the categories
$categories = get_categories(array(
	'hide_empty' => 0,
	'number' => 1000
));

// 'walk' all the categories
$td_category_walker_panel = new td_category_walker_panel;
$td_category_walker_panel->walk($categories, 4);

// add each category panel
foreach ($td_category_walker_panel->td_category_buffer as $display_category_name => $category_id) {
	?>
	<!-- LAYOUT SETTINGS -->
	<?php
	echo td_panel_generator::ajax_box( $display_category_name, array(
			'td_ajax_calling_file' => basename(__FILE__),
			'td_ajax_box_id' => 'td_get_category_section_by_id',
			'category_id' => $category_id,
			'tdb_category_template_is_set' => $tdb_category_template_is_set
		), '', 'td_panel_box_category_individual_settings_cat_' . $category_id
	);
}//end foreach
