<?php

$ad_spot_id = td_util::get_http_post_val('ad_spot_id');

if (empty($ad_spot_id)) {
	$ad_spot_id = td_global::$current_ad_id;

	if (!isset($ad_spot_id)) {
		return;
	}
}

$ad_fields = td_api_ad::get_key( $ad_spot_id, 'fields' );

$ad_field_code_title = 'کد آگهی شما';
$ad_field_code_description = 'کد تبلیغ خود را در اینجا قرار دهید. Google AdSense به صورت خودکار پاسخگو می شود.';

// ad_field_notice - if is present => it is shown
// all other fields - (if is present and not 'false') or it is not preset => it is shown
if (isset($ad_fields['ad_field_notice']) && $ad_fields['ad_field_notice'] !== false) {
	?>
	<div class="td-box-row">
		<div class="td-box-description td-box-full">
			<span class="td-box-title">توجه:</span>
			<p>
				<?php
					printf( '%1$s', $ad_fields['ad_field_notice'] )
				?>
			</p>
		</div>
		<div class="td-box-row-margin-bottom"></div>
	</div>
<?php
}


if (!isset($ad_fields['ad_field_code']) || (isset($ad_fields['ad_field_code']) && $ad_fields['ad_field_code'] !== false)) {
	?>

	<!-- ad box code -->
	<div class="td-box-row">
		<div class="td-box-description">
        <span class="td-box-title">
	        <?php
	        if ( isset( $ad_fields['ad_field_code']['title'] ) ) {
		        printf( '%1$s', $ad_fields['ad_field_code']['title'] );
	        } else {
		        printf( '%1$s', $ad_field_code_title );
	        }
	        ?>
        </span>

			<p>
				<?php
				if ( isset( $ad_fields['ad_field_code']['desc'] ) ) {
					printf( '%1$s', $ad_fields['ad_field_code']['desc'] );
				} else {
					printf( '%1$s', $ad_field_code_description );
				}
				?>
			</p>
		</div>
		<div class="td-box-control-full">
			<?php
			echo td_panel_generator::textarea( array(
				'ds'        => 'td_ads',
				'item_id'   => $ad_spot_id,
				'option_id' => 'ad_code',
			) );
			?>
		</div>
	</div>

	<?php
}




if (!isset($ad_fields['ad_field_title']) || (isset($ad_fields['ad_field_title']) && $ad_fields['ad_field_title'] !== false)) {
	?>

	<!-- A title for the Ad-->
	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title">عنوان AD:</span>

			<p>عنوانی برای آگهی، مانند - <strong>تبلیغ</strong> - اگر آن را خالی بگذارید، نقطه تبلیغاتی
			عنوان ندارند</p>
		</div>
		<div class="td-box-control-full">
			<?php
			echo td_panel_generator::input( array(
				'ds'        => 'td_option',
				'option_id' => 'tds_' . $ad_spot_id . '_title'
			) );
			?>
		</div>
	</div>

	<?php
}



if (!isset($ad_fields['ad_field_after_paragraph']) || (isset($ad_fields['ad_field_after_paragraph']) && $ad_fields['ad_field_after_paragraph'] !== false)) {
	?>

	<!-- After paragraph  //alignment & after paragraph settings only for inline ads-->
	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title">بعد از پاراگراف:</span>

			<p>بعد از چند پاراگراف تبلیغ نمایش داده می شود. موضوع محتوای هر پست و آن را تجزیه و تحلیل خواهد کرد
			بعد از تعداد پاراگراف انتخاب شده، آگهی را تزریق می کند</p>
		</div>
		<div class="td-box-control-full">
			<?php
			echo td_panel_generator::input( array(
				'ds'        => 'td_option',
				'option_id' => 'tds_inline_ad_paragraph'
			) );
			?>
		</div>
	</div>

	<?php
}


if (!isset($ad_fields['ad_field_position_content']) || (isset($ad_fields['ad_field_position_content']) && $ad_fields['ad_field_position_content'] !== false)) {
	?>

	<!-- DISPLAY VIEW -->
	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title">موقعیت آگهی در محتوا</span>
			<p>موقعیت تبلیغ در محتوا شناور به چپ، تمام عرض پست یا شناور به راست.</p>
		</div>
		<div class="td-box-control-full td-panel-module">
			<?php
			$img_left = TDC_URL_LEGACY_COMMON . '/wp_booster/wp-admin/images/panel/rec-left.png';
			$img_center = TDC_URL_LEGACY_COMMON . '/wp_booster/wp-admin/images/panel/rec-center.png';
			$img_right = TDC_URL_LEGACY_COMMON . '/wp_booster/wp-admin/images/panel/rec-right.png';

			echo td_panel_generator::visual_select_o(array(
				'ds' => 'td_option',
				'option_id' => 'tds_inline_ad_align',
				'values' => array(
					array('text' => '', 'title' => 'Left', 'val' => 'left', 'img' => $img_left),
					array('text' => '', 'title' => 'Full Width', 'val' => '', 'img' => $img_center),
					array('text' => '', 'title' => 'Right', 'val' => 'right', 'img' => $img_right)
				)
			));
			?>
		</div>
	</div>

<?php
}


if (!isset($ad_fields['ad_field_advantage_usage']) || (isset($ad_fields['ad_field_advantage_usage']) && $ad_fields['ad_field_advantage_usage'] !== false)) {
	?>
	<div class="td-box-row">
		<div class="td-box-description td-box-full">
			<span class="td-box-title">استفاده از قبل:
			</span>

			<p>
				<?php
				if ( isset( $ad_fields['ad_field_advantage_usage'] ) ) {
					printf( '%1$s', $ad_fields['ad_field_advantage_usage'] );
				} else {
					//echo 'If you leave the AdSense size boxes on Auto, the theme will automatically resize the <strong>google ads</strong>. For more info follow this <a href="http://forum.tagdiv.com/header-ad/" target="_blank">link</a>';
					echo 'اگر کادرهای اندازه AdSense را روی Auto رها کنید، اندازه طرح زمینه به طور خودکار <strong>Google Ads</strong> را تغییر می‌دهد. لطفاً توجه داشته باشید که گزینه‌های غیرفعال کردن تبلیغات را می‌توان فقط برای تبلیغات غیر ادسنس فعال کرد.';
				}
				?>
			</p>
		</div>
		<div class="td-box-row-margin-bottom"></div>
	</div>
<?php
}


if( TD_THEME_NAME == 'Newspaper' && ( !isset($ad_fields['ad_field_hide_for_admins']) || ( isset($ad_fields['ad_field_hide_for_admins']) && $ad_fields['ad_field_hide_for_admins'] !== false ) ) ){
    ?>

    <!-- disable ad for admins/editors -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title td-title-on-row">غیرفعال کردن برای مدیران/ویراستاران</span>

            <p></p>
        </div>
        <div class="td-box-control-full">
            <span>
            <?php
            echo td_panel_generator::checkbox( array(
                'ds'          => 'td_ads',
                'item_id'     => $ad_spot_id,
                'option_id'   => 'disable_for_admins',
                'true_value'  => 'yes',
                'false_value' => ''
            ) );
            ?>
            </span>

        </div>
    </div>

<?php
}


if (!isset($ad_fields['ad_field_desktop']) || (isset($ad_fields['ad_field_desktop']) && $ad_fields['ad_field_desktop'] !== false)) {
	?>

	<!-- disable ad on monitor -->
	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title td-title-on-row">غیرفعال کردن روی دسکتاپ</span>

			<p></p>
		</div>
		<div class="td-box-control-full">
            <span>
            <?php
            echo td_panel_generator::checkbox( array(
	            'ds'          => 'td_ads',
	            'item_id'     => $ad_spot_id,
	            'option_id'   => 'disable_m',
	            'true_value'  => 'yes',
	            'false_value' => ''
            ) );
            ?>
            </span>
            <span class="td-content-float-right td_float_clear_both td-content-padding-right-40">
                <span class="td-content-padding-right-40 td-adsense-size">اندازه AdSense: </span>
                <span class="td-content-float-right">
                    <?php
                    echo td_panel_generator::dropdown( array(
	                    'ds'        => 'td_ads',
	                    'item_id'   => $ad_spot_id,
	                    'option_id' => 'm_size',
	                    'values'    => td_panel_generator::$google_ad_sizes
                    ) );
                    ?>
            </span>

		</div>
	</div>

<?php
}
?>

<!-- disable ad on tablet landscape -->
<?php
if (!isset($ad_fields['ad_field_landscape']) || (isset($ad_fields['ad_field_landscape']) && $ad_fields['ad_field_landscape'] !== false)) {
	?>

	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title td-title-on-row">غیرفعال کردن در منظره تبلت</span>

			<p></p>
		</div>
		<div class="td-box-control-full">
            <span>
            <?php
            echo td_panel_generator::checkbox( array(
	            'ds'          => 'td_ads',
	            'item_id'     => $ad_spot_id,
	            'option_id'   => 'disable_tl',
	            'true_value'  => 'yes',
	            'false_value' => ''
            ) );
            ?>
            </span>
            <span class="td-content-float-right td_float_clear_both td-content-padding-right-40">
                <span class="td-content-padding-right-40 td-adsense-size">اندازه AdSense: </span>
                <span class="td-content-float-right">
                    <?php
                    echo td_panel_generator::dropdown( array(
	                    'ds'        => 'td_ads',
	                    'item_id'   => $ad_spot_id,
	                    'option_id' => 'tl_size',
	                    'values'    => td_panel_generator::$google_ad_sizes
                    ) );
                    ?>
            </span>

		</div>
	</div>

<?php
}
?>


<!-- disable ad on tablet portrait -->
<?php
if (!isset($ad_fields['ad_field_portrait']) || (isset($ad_fields['ad_field_portrait']) && $ad_fields['ad_field_portrait'] !== false)) {
	?>

	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title td-title-on-row">غیرفعال کردن در پرتره تبلت</span>

			<p></p>
		</div>
		<div class="td-box-control-full">
            <span>
            <?php
            echo td_panel_generator::checkbox( array(
	            'ds'          => 'td_ads',
	            'item_id'     => $ad_spot_id,
	            'option_id'   => 'disable_tp',
	            'true_value'  => 'yes',
	            'false_value' => ''
            ) );
            ?>
            </span>
            <span class="td-content-float-right td_float_clear_both td-content-padding-right-40">
                <span class="td-content-padding-right-40 td-adsense-size">اندازه AdSense: </span>
                <span class="td-content-float-right">
                    <?php
                    echo td_panel_generator::dropdown( array(
	                    'ds'        => 'td_ads',
	                    'item_id'   => $ad_spot_id,
	                    'option_id' => 'tp_size',
	                    'values'    => td_panel_generator::$google_ad_sizes
                    ) );
                    ?>
            </span>

		</div>
	</div>

<?php
}
?>


<!-- disable ad on phones -->
<?php
if (!isset($ad_fields['ad_field_phone']) || (isset($ad_fields['ad_field_phone']) && $ad_fields['ad_field_phone'] !== false)) {
	?>

	<div class="td-box-row">
		<div class="td-box-description">
			<span class="td-box-title">غیرفعال کردن در تلفن</span>

			<p>
				<?php
				if ( isset( $ad_fields['ad_field_phone']['desc'] ) ) {
					printf( '%1$s', $ad_fields['ad_field_phone']['desc'] );
				}
				?>
			</p>
		</div>
		<div class="td-box-control-full">
            <span>
            <?php
            echo td_panel_generator::checkbox( array(
	            'ds'          => 'td_ads',
	            'item_id'     => $ad_spot_id,
	            'option_id'   => 'disable_p',
	            'true_value'  => 'yes',
	            'false_value' => ''
            ) );
            ?>
            </span>
            <span class="td-content-float-right td_float_clear_both td-content-padding-right-40">
                <span class="td-content-padding-right-40 td-adsense-size">اندازه AdSense: </span>
                <span class="td-content-float-right">
                    <?php
                    echo td_panel_generator::dropdown( array(
	                    'ds'        => 'td_ads',
	                    'item_id'   => $ad_spot_id,
	                    'option_id' => 'p_size',
	                    'values'    => td_panel_generator::$google_ad_sizes
                    ) );
                    ?>
            </span>
		</div>
	</div>

<?php
}
?>