<!-- Global block template -->
<?php echo td_panel_generator::box_start('الگوی سرصفحه بلوک جهانی', true); ?>

    <!-- text -->
    <div class="td-box-row">
        <div class="td-box-description td-box-full">
        <p>این الگوی هدر در کل سایت اعمال خواهد شد. موضوع همچنین سعی می‌کند ویجت‌های پیش‌فرض را طوری تنظیم کند که به همان سبک به نظر برسند
        با الگوی بلوک انتخاب شده در اینجا.</p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <!-- GLOBAL BLOCK TEMPLATE SELECT -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">قالب بلوک هدر</span>
            <p>می توانید الگو را روی هر بلوک و ویجت بازنویسی کنید.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_global_block_template',
                'values' => td_api_block_template::_helper_generate_block_templates()
            ));
            ?>
        </div>
    </div>
<?php echo td_panel_generator::box_end();?>


<!-- Thumbs on Modules/Blocks -->
<?php
    echo td_panel_generator::ajax_box('thumb در ماژول ها/بلوک ها', array(
        'td_ajax_calling_file' => basename(__FILE__),
        'td_ajax_box_id' => 'td_thumbs_on_modules_and_blocks',
        ), '', 'td_panel_box_thumb_on_modules'
    );
?>




<!-- Category label on modules -->
<?php echo td_panel_generator::box_start('برچسب رده در ماژول ها / بلوک ها', false); ?>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <span class="td-box-title">اطلاعات بیشتر:</span>
            <p>از اینجا می توانید تگ دسته را از ماژول ها نشان دهید یا پنهان کنید. <?php echo ('enabled' !== td_util::get_option('tds_white_label')) ? '<a target="_blank" href="http://forum.tagdiv.com/category-tag-on-modulesblocks/" > درباره ماژول ها بیشتر بخوانید</a>' : '' ?> </p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>



    <?php
    foreach (td_api_module::get_all() as $td_module_class => $td_module_array) {
        if ($td_module_array['category_label'] === true) {
            ?>
            <!-- <?php printf( '%1$s', $td_module_array['text'] ) ?> -->
            <div class="td-box-row">
                <div class="td-box-description">
                    <span class="td-box-title"><?php printf( '%1$s',$td_module_array['text'] . td_panel_generator::helper_generate_used_on_block_list($td_module_array['used_on_blocks'] ) ) ?></span>
                    <p>برچسب دسته را پنهان یا نمایش دهید</p>
                </div>
                <div class="td-box-control-full">
                    <?php
                    echo td_panel_generator::checkbox(array(
                        'ds' => 'td_option',
                        'option_id' => 'tds_category_' . td_api_module::_helper_get_module_name_from_class($td_module_class),
                        'true_value' => 'yes',
                        'false_value' => ''
                    ));
                    ?>
                </div>
            </div>
            <?php
        }
    }

    ?>
<?php echo td_panel_generator::box_end();?>



<!-- Meta info on Modules/Blocks -->
<?php echo td_panel_generator::box_start('اطلاعات متا در مورد ماژول ها / بلوک ها', false); ?>

<!-- Show author name -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش نام نویسنده</span>
        <p>فعال یا غیرفعال کردن نام نویسنده (در بلوک ها و ماژول ها)</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_m_show_author_name',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<!-- Show date -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش تاریخ</span>
        <p>فعال یا غیرفعال کردن تاریخ ارسال (در بلوک ها و ماژول ها)</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_m_show_date',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<!-- Show modified date -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش تاریخ اصلاح شده</span>
        <p>نمایش تاریخ پست اصلاح شده به جای تاریخ انتشار در بلوک ها و ماژول ها (تاریخ نمایش باید فعال باشد)</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_m_show_modified_date',
            'true_value' => 'yes',
            'false_value' => ''
        ));
        ?>
    </div>
</div>

<!-- SHow comment count -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش تعداد نظر</span>
        <p>فعال یا غیرفعال کردن شماره نظر (در بلوک ها و ماژول ها)</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_m_show_comments',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<!-- Show Reviews -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمایش مرور</span>
        <p>فعال یا غیرفعال کردن بررسی ها (در بلوک ها و ماژول ها)</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_m_show_review',
            'true_value' => '',
            'false_value' => 'hide'
        ));
        ?>
    </div>
</div>

<!-- Show Nofollow -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">NOFOLLOW را اضافه کنید</span>
        <p>اضافه کردن یا حذف nofollow در پیوند انگشت thumb (در بلوک ها و ماژول ها)</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_m_nofollow_image',
            'true_value' => 'yes',
            'false_value' => ''
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>

<!-- LOADER BACKGROUND -->
<?php echo td_panel_generator::box_start('تصویر لودر', false); ?>

<!-- BACKGROUND UPLOAD -->
<div class="td-box-row">
    <div class="td-box-description td-box-full">
        <span class="td-box-title">دستورالعمل:</span>
        <p>لودر پیش فرض را با یک تصویر بازنویسی کنید. اندازه پیشنهادی 59x59px است.</p>
    </div>
    <div class="td-box-row-margin-bottom"></div>
    <div class="td-box-description">
        <span class="td-box-title">عکس</span>
        <p>یک تصویر آپلود کنید</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::upload_image(array(
            'ds' => 'td_option',
            'option_id' => 'tds_loader_background_image'
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>

<!-- 7 days post sorting -->
<?php echo td_panel_generator::box_start('24/48 ساعت و 7 روز پس از مرتب سازی', false ); ?>

<!-- text -->
<div class="td-box-row">
	<div class="td-box-description td-box-full">
		<ul>
            <li>هنگامی که این گزینه را فعال می کنید، گزینه های مرتب سازی جدید کار می کنند و در هر بلوک قابل انتخاب خواهند بود (24/48 ساعت گذشته و 7 روز گذشته محبوب).</li>
            <li>این گزینه‌های مرتب‌سازی، پست‌هایی را انتخاب می‌کنند که در 24/48 ساعت یا 7 روز گذشته محبوب بوده‌اند و بر اساس بازدیدهای صفحه مرتب شده‌اند.</li>
            <li>لطفاً توجه داشته باشید که این گزینه با یک جریمه عملکرد کوچک همراه است و هنوز با افزونه های کش کار نمی کند. هنگامی که حافظه پنهان فعال است، مرتب‌سازی تخمینی از محبوبیت در 24/48 ساعت یا 7 روز گذشته خواهد بود.</li>
        </ul>
	</div>
	<div class="td-box-row-margin-bottom"></div>
</div>

<!-- use 7 days post sorting -->
<div class="td-box-row">
	<div class="td-box-description" style="width: 400px;">
		<span class="td-box-title">از 24/48 ساعت گذشته و 7 روز پس از مرتب سازی استفاده کنید</span>
		<p>مرتب سازی محبوب 24/48 ساعت و 7 روز گذشته را فعال یا غیرفعال کنید.</p>
	</div>
	<div class="td-box-control-full" style="width: 320px;">
		<?php
		echo td_panel_generator::checkbox(
            array(
                'ds' => 'td_option',
                'option_id' => 'tds_p_enable_7_days_count',
                'true_value' => 'enabled',
                'false_value' => ''
            )
        );
		?>
	</div>
</div>

<?php echo td_panel_generator::box_end();?>

<!-- generated css -->
<?php echo td_panel_generator::box_start('درون خطی CSS', false ); ?>

<!-- minify inline css -->
<div class="td-box-row">
    <div class="td-box-description" style="width: 400px;">
        <span class="td-box-title">مینیفای درون خطی CSS</span>
        <p>فعال کردن این گزینه CSS درون خطی تولید شده توسط تم و افزونه های ما را به حداقل می رساند.</p>
    </div>
    <div class="td-box-control-full" style="width: 320px;">
        <?php
        echo td_panel_generator::checkbox(
            array(
                'ds' => 'td_option',
                'option_id' => 'tds_minify_inline_css',
                'true_value' => '',
                'false_value' => 'disabled'
            )
        );
        ?>
    </div>
</div>

<!-- aggregate inline css -->
<div class="td-box-row">
    <div class="td-box-description" style="width: 400px;">
        <span class="td-box-title">CSS درون خطی جمع آوری کنید</span>
        <p>فعال کردن این گزینه تمام CSS های درون خطی تولید شده توسط تم و افزونه های ما را جمع آوری می کند و آن را در هدر قرار می دهد.</p>
    </div>
    <div class="td-box-control-full" style="width: 320px;">
        <?php
        echo td_panel_generator::checkbox(
            array(
                'ds' => 'td_option',
                'option_id' => 'tds_aggregate_inline_css',
                'true_value' => 'enabled',
                'false_value' => ''
            )
        );
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>