<?php


class tds_config {

	static $js_vue_files = array(
		'tdsVue'                            => '/assets/js/vue/external/vue.js',
        'tdsVueRouter'                      => '/assets/js/vue/external/vue-router.js',
        'tdsVuex'                           => '/assets/js/vue/external/vuex.js',

		'tdsError'                          => '/assets/js/vue/subscription/error.js',
        'tdsModal'                          => '/assets/js/vue/subscription/modal.js',
        'tdsSubscriptionsPaginated'         => '/assets/js/vue/subscription/subscriptions-paginated.js',
        'tdsDashboard'                      => '/assets/js/vue/subscription/dashboard.js',
        'tdsBilling'                        => '/assets/js/vue/subscription/billing.js',
        'tdsSubscription'                   => '/assets/js/vue/subscription/subscription.js',
        'tdsCoupons'                        => '/assets/js/vue/subscription/coupons.js',
        'tdsPlan'                           => '/assets/js/vue/subscription/plan.js',
        'tdsPayment'                        => '/assets/js/vue/subscription/payment.js',
		'tdsWizardLocker'                   => '/assets/js/vue/subscription/wizard-locker.js',
		'tdsPage'                           => '/assets/js/vue/subscription/page.js',
		'tdsSettings'                       => '/assets/js/vue/subscription/settings.js',
		'tdsIndex'                          => '/assets/js/vue/subscription/index.js',
        'tdsRouter'                         => '/assets/js/vue/subscription/router/router.js',

		'tdtError'                          => '/assets/js/vue/link_conversion/error.js',
		'tdtModal'                          => '/assets/js/vue/link_conversion/modal.js',
		'tdtSelect'                         => '/assets/js/vue/link_conversion/select.js',
		'tdtIntro'                          => '/assets/js/vue/link_conversion/intro.js',
        'tdtTracker'                        => '/assets/js/vue/link_conversion/tracker.js',
        'tdtSettings'                       => '/assets/js/vue/link_conversion/settings.js',
        'tdtIndex'                          => '/assets/js/vue/link_conversion/index.js',
        'tdtRouter'                         => '/assets/js/vue/link_conversion/router/router.js',

        'tdsApi'                            => '/assets/js/admin/tdsApi.js',
	);

	static $js_files_for_front = array (
        'tdsLeads'                          => '/assets/js/frontend/tdsLeads.js', // add leads js
		'tdsStore'                          => '/assets/js/frontend/tdsStore.js',
		'tdsMain'                           => '/assets/js/frontend/tdsMain.js',
	);

    static $js_files_for_front_minify_only = array (
        'tdsLogin'                          => '/assets/js/frontend/tdsLogin.js',
    );

	static $js_lockers_preview = array (
		'tdsLockersPreview'                 => '/assets/js/admin/lockers.js'
	);

	static $js_subscriptions = array (
		'tdsSubscriptions'                  => '/assets/js/admin/subscriptions.js'
	);

	static $js_gutenberg_blocks = array (
		'tdsBlocks'                         => '/assets/js/admin/blocks.js'
	);

	static $year_plans = null;
	static $month_plans = null;
	static $week_plans = null;
	static $day_plans = null;
	static $free_plans = null;
	static $unlimited_plans = null;
	static $with_credits_plans = null;
	static $donation_plans = null;

	static function on_tdc_loaded() {

        self::register_styles();

		td_api_block::add('tds_leads',
			array(
				'map_in_td_composer' => true,
				"name" => 'Leads',
				"base" => "tds_leads",
				'tdc_category' => 'Blocks',
				'file' => TDS_PATH . '/includes/shortcodes/tds_leads.php',
				'tdc_style_params' => array(
				    'show_version',
				    'title_text',
                    'title_tag',
                    'msg_composer',
                    'input_placeholder',
                    'unsub_msg',
                    'btn_text',
                    'pp_msg',
                    'el_class'
                ),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								'title_text' => 'Subscribe',
								'input_placeholder' => 'Your email address',
								'btn_horiz_align' => 'content-horiz-center',
								'pp_checkbox' => 'yes',
								'pp_msg' => 'SSd2ZSUyMHJlYWQlMjBhbmQlMjBhY2NlcHQlMjB0aGUlMjAlM0NhJTIwaHJlZiUzRCUyMiUyMyUyMiUzRVByaXZhY3klMjBQb2xpY3klM0MlMkZhJTNFLg=='
							)
						)
					)
				),
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "show_version",
                            "type" => "dropdown",
                            "value" => array(
                                'Subscribe form' => '',
                                'Unsubscribe form' => 'unsub'
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "list",
                            "type" => "dropdown",
                            "value" => self::get_lists(),
                            "heading" => 'Mailing list',
                            "description" => "The list in which you want to store the received email addresses.",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),
                        array(
                            "param_name" => "successful_submit_rdr_url",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Subscribe redirect url',
                            "description" => "Optional - a custom url for when the guest successfully subscribes",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                        ),
                        array(
                            "param_name" => "unsubscribe_rdr_url",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Unsubscribe redirect url',
                            "description" => "Optional - a custom url for when the guest unsubscribes",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "double_opt_in",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Double opt-in email',
                            "description" => "Add an additional step to the email subscription opt-in process, requiring a user to verify their email address and confirm interest.",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "ajax_submit",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'AJAX submit',
                            "description" => "The form submits without refreshing the page.",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
						array(
							'param_name' => 'title_text',
							'type' => 'textfield',
							'value' => '',
							'heading' => 'Title text',
							'description' => '',
							'class' => 'tdc-textfield-extrabig',
						),
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/title_seo.png",
                        ),
                        array(
                            "param_name" => "title_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Title space',
                            "description" => "",
                            "placeholder" => "20",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Message',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "msg_composer",
                            "type" => "dropdown",
                            "value" => array(
                                'No message' => '',
                                'Success message' => 'success',
                                'Error message' => 'error',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "msg_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'Below title' => 'title',
                                'Below form' => 'form',
                            ),
                            "heading" => 'Position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "msg_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "0 0 16px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "msg_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "8px 12px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Success messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "all_msg_succ_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "all_msg_succ_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "msg_succ_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "3",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Error messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "all_msg_err_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "all_msg_err_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "msg_err_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "3",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Input & Button',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "display",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Columns' => 'row',
                                'Row' => 'column',
                            ),
                            "heading" => 'Display',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "gap",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Gap',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Input',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
						array(
							"param_name" => "input_placeholder",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Placeholder text',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big"
						),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "input_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "12px 15px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "input_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "1px 0 1px 1px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "input_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "input_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							"heading" => 'Unsubscribe message',
							"value" => "",
							"class" => "tdc-separator-small",
						),
                        array(
                            'param_name' => 'unsub_msg',
                            'type' => 'textarea_raw_html',
                            'value' => 'WW91IGhhdmUgYWxyZWFkeSBzdWJzY3JpYmVkIHRvIHRoaXMgbWFpbGluZyBsaXN0IQ==',
                            'heading' => 'Text',
                            'description' => '',
                            'class' => 'tdc-textarea-extrasmall',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "unsub_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "",
                            "info_img" => ""
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							"heading" => 'Button',
							"value" => "",
							"class" => "tdc-separator-small",
						),
						array(
							"param_name" => "btn_text",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Subscribe text',
							"description" => "",
							"placeholder" => "Subscribe",
							"holder" => "div",
							"class" => "tdc-textfield-big"
						),
						array(
							"param_name" => "btn_text_un",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Unsubscribe text',
							"description" => "",
							"placeholder" => "Unsubscribe",
							"holder" => "div",
							"class" => "tdc-textfield-big"
						),
                        array(
                            "param_name" => "hide_btn_un",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Hide unsubscribe button',
                            "description" => "Hide the unsubscribe button, after a successful subscription",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            'param_name' => 'btn_tdicon',
                            'type' => 'icon',
                            'heading' => 'Subscribe icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                            "group"       => '',
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'btn_tdicon_un',
                            'type' => 'icon',
                            'heading' => 'Unsubscribe icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                            "group"       => '',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "btn_icon_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'After text' => 'after',
                                'Before text' => 'before',
                            ),
                            "heading" => 'Icon position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "btn_icon_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Size',
                            "description" => "",
                            "placeholder" => "16",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "btn_icon_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "6",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            'param_name' => 'btn_icon_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Icon vertical alignment',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-10',
                            'range_max' => '10',
                            'range_step' => '1',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "btn_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "15",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "all_btn_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "all_btn_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "btn_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "",
                            "info_img" => ""
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							"heading" => 'Privacy Policy',
							"value" => "",
							"class" => "",
						),
                        array(
                            "param_name" => "pp_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Top space',
                            "description" => "",
                            "placeholder" => "16",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Checkbox',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "pp_checkbox",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Enable checkbox',
                            "description" => "Enable privacy policy checkbox",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            'param_name' => 'pp_check_size',
                            'type' => 'range-responsive',
                            'value' => '16',
                            'heading' => 'Size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '12',
                            'range_max' => '30',
                            'range_step' => '1',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "pp_check_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "8",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "pp_check_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Text',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'pp_msg',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Privacy policy text',
                            'description' => '',
                            'class' => 'tdc-textarea-extrasmall',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Title color',
                            "param_name" => "title_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Title text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Message',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Success messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "msg_succ_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "msg_succ_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_msg_succ_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Error messages',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "msg_error_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "msg_err_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_msg_err_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_msg', true, 'Message text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Input',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "input_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Placeholder text color',
                            "param_name" => "input_place_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "input_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background focus color',
                            "param_name" => "input_bg_f",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "input_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border focus color',
                            "param_name" => "input_border_color_f",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_input', true, 'Input text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Unsubscribe message',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "unsub_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_unsub', true, 'Unsubscribe text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Button',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "btn_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "btn_icon_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Icon hover color',
                            "param_name" => "btn_icon_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "btn_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background hover color',
                            "param_name" => "btn_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "all_btn_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border hover color',
                            "param_name" => "btn_border_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_btn', true, 'Button text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Privacy policy',
                            "value" => "",
                            "class" => "",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Checkbox',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Checked square color',
                            "param_name" => "pp_check_square",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "pp_check_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background checked color',
                            "param_name" => "pp_check_bg_c",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "pp_check_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border checked color',
                            "param_name" => "pp_check_border_color_c",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Text',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "pp_check_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Links color',
                            "param_name" => "pp_check_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Links hover color',
                            "param_name" => "pp_check_color_a_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_pp', true, 'Privacy policy text', 'Style' ),
					self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_locker',
			array(
				"map_in_td_composer" => false,
				"name" => 'TDS Locker',
				"base" => 'tds_locker',
				"file" => TDS_PATH . '/includes/shortcodes/tds_locker.php',
				"params" => array(),
			)
		);

		td_api_block::add( 'tds_locker_credits',
			array(
				"map_in_td_composer" => false,
				"name" => 'TDS Locker Credits',
				"base" => 'tds_locker_credits',
				"file" => TDS_PATH . '/includes/shortcodes/tds_locker_credits.php',
				"params" => [],
			)
		);

        td_api_block::add( 'tds_leads_unsubscribe',
            array(
                "map_in_td_composer" => true,
                "name" => 'Leads unsubscribe button',
                "base" => 'tds_leads_unsubscribe',
                'tdc_category' => 'Blocks',
                "file" => TDS_PATH . '/includes/shortcodes/tds_leads_unsubscribe.php',
                'tdc_style_params' => array(
                    'button_text',
                    'tdicon',
                    'el_class',
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "unsubscribe_rdr_url",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Unsubscribe redirect url',
                            "description" => "Optional - a custom url for when the guest unsubscribes",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Layout',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            'param_name' => 'button_text',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Button text',
                            'description' => '',
                            'placeholder' => 'Unsubscribe',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            'param_name' => 'all_border',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'placeholder' => '0',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            "param_name" => "all_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'border_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'placeholder' => '0',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            'param_name' => 'padd',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'placeholder' => '14px 24px 15px',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            'param_name' => 'min_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Minimum width',
                            'description' => '',
                            'placeholder' => '',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            "param_name" => "display",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Default' => 'default',
                                'Inline' => 'inline',
                                'Full width' => 'full',
                            ),
                            "heading" => 'Display',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "",
                            "info_img" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Icon',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            'param_name' => 'tdicon',
                            'type' => 'icon',
                            'heading' => 'Icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                            "group"       => '',
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'icon_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Size',
                            'description' => '',
                            'placeholder' => '15',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            "param_name" => "icon_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'After text' => '',
                                'Before text' => 'before',
                            ),
                            "heading" => 'Position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'icon_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Space',
                            'description' => '',
                            'placeholder' => '10',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            'param_name' => 'icon_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Vertical alignment',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-10',
                            'range_max' => '10',
                            'range_step' => '1',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Style',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "text_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "text_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "icon_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Icon hover color',
                            "param_name" => "icon_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "bg_color",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Background color",
                            "value"      => "",
                            "class"      => "td-colorpicker-double-a",
                            "group"      => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "bg_color_h",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Background hover color",
                            "value"      => "",
                            "class"      => "td-colorpicker-double-b",
                            "group"      => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "all_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border hover color',
                            "param_name" => "border_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Shadow', 0, 0, 0 ),
                    td_config_helper::get_map_block_shadow_array('shadow_h', 'Shadow hover', 0, 0, 0, '', '', 0, false ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Fonts',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_txt', true, 'Button text' ),
                    self::get_block_style()
                )
            )
        );

		td_api_block::add( 'tds_plans_button',
			array(
				"map_in_td_composer" => true,
				"name" => 'Plans button',
				"base" => 'tds_plans_button',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_plans_button.php',
				'tdc_style_params' => array(
                    'free_plan',
                    'year_plan',
                    'month_plan',
                    'week_plan',
                    'day_plan',
                    'def_plan',
				    'button_text',
                    'tdicon',
                    'el_class',
                ),
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "free_plan",
                            "type" => "dropdown",
                            "value" => self::get_plans('free'),
                            "heading" => 'طرح رایگان',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                            "info_img" => "",
                            'toggle_enable_params' => 'free-plan-btn',
                            'toggle_enable_params_reverse' => true,
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small tdc-free-plan-sep",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "year_plan",
                            "type" => "dropdown",
                            "value" => self::get_plans(),
                            "heading" => 'Plan 1',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                            "info_img" => "",
                            'toggle_enabled_by' => 'free-plan-btn',
                            'options_to_disable' => '__day __week __month __year __unlimited __credits __donation',
                        ),
						array(
                            "param_name" => "month_plan",
                            "type" => "dropdown",
                            "value" => self::get_plans(),
                            "heading" => 'Plan 2',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                            "info_img" => "",
                            'toggle_enabled_by' => 'free-plan-btn',
                            'options_to_disable' => '__day __week __month __year __unlimited __credits __donation',
                        ),
                        array(
                            "param_name" => "def_plan",
                            "type" => "dropdown",
                            "value" => array(
                                'Switcher' => '',
                                'Plan 1' => 'annual',
                                'Plan 2' => 'monthly',
                            ),
                            "heading" => 'Default plan',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                            'toggle_enabled_by' => 'free-plan-btn',
                        ),
                        array(
                            "param_name" => "auto_unlock",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Auto Unlock",
                            "description" => "This option enables automatic unlocking of posts after a successful purchase.",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Layout',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            'param_name' => 'button_text',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Button text',
                            'description' => '',
                            'placeholder' => 'Choose plan',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            'param_name' => 'all_border',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'placeholder' => '0',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            "param_name" => "all_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'border_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'placeholder' => '0',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            'param_name' => 'padd',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'placeholder' => '14px 24px 15px',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            'param_name' => 'min_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Minimum width',
                            'description' => '',
                            'placeholder' => '',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            "param_name" => "display",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Default' => 'default',
                                'Inline' => 'inline',
                                'Full width' => 'full',
                            ),
                            "heading" => 'Display',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "",
                            "info_img" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Icon',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            'param_name' => 'tdicon',
                            'type' => 'icon',
                            'heading' => 'Icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                            "group"       => '',
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'icon_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Size',
                            'description' => '',
                            'placeholder' => '15',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            "param_name" => "icon_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'After text' => '',
                                'Before text' => 'before',
                            ),
                            "heading" => 'Position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'icon_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Space',
                            'description' => '',
                            'placeholder' => '10',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            'param_name' => 'icon_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Vertical alignment',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-10',
                            'range_max' => '10',
                            'range_step' => '1',
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Style',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "text_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "text_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "icon_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Icon hover color',
                            "param_name" => "icon_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "bg_color",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Background color",
                            "value"      => "",
                            "class"      => "td-colorpicker-double-a",
                            "group"      => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "bg_color_h",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Background hover color",
                            "value"      => "",
                            "class"      => "td-colorpicker-double-b",
                            "group"      => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "all_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border hover color',
                            "param_name" => "border_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Shadow', 0, 0, 0 ),
                    td_config_helper::get_map_block_shadow_array('shadow_h', 'Shadow hover', 0, 0, 0, '', '', 0, false ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Fonts',
                            "value" => "",
                            "class" => "tdc-separator-small",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_txt', true, 'Button text' ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_plans_price',
			array(
				"map_in_td_composer" => true,
				"name" => 'Plans price',
				"base" => 'tds_plans_price',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_plans_price.php',
                'tdc_start_values' => base64_encode(
                    json_encode(
						array(
							array(
								'curr_txt' => '$',
							)
						)
                    )
                ),
				'tdc_style_params' => array(
                    'free_plan',
                    'year_plan',
                    'month_plan',
                    'def_plan',
                    'curr_txt',
				    'el_class',
                ),
				"params" => array_merge(
					array(
						array(
                            "param_name" => "free_plan",
                            "type" => "dropdown",
                            "value" => self::get_plans('free'),
                            "heading" => 'طرح رایگان',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                            "info_img" => "",
                            'toggle_enable_params' => 'free-plan-price',
                            'toggle_enable_params_reverse' => true,
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small tdc-free-plan-sep",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "year_plan",
                            "type" => "dropdown",
                            "value" => self::get_plans(),
                            "heading" => 'Plan 1',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                            "info_img" => "",
                            'toggle_enabled_by' => 'free-plan-price',
                            'options_to_disable' => '__day __week __month __year __unlimited __credits __donation',
                        ),
						array(
                            "param_name" => "month_plan",
                            "type" => "dropdown",
                            "value" => self::get_plans(),
                            "heading" => 'Plan 2',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                            "info_img" => "",
                            'toggle_enabled_by' => 'free-plan-price',
                            'options_to_disable' => '__day __week __month __year __unlimited __credits __donation',
                        ),
                        array(
                            "param_name" => "def_plan",
                            "type" => "dropdown",
                            "value" => array(
                                'Switcher' => '',
                                'Plan 1' => 'annual',
                                'Plan 2' => 'monthly',
                            ),
                            "heading" => 'Default plan',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                            'toggle_enabled_by' => 'free-plan-price',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Layout',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "curr_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Currency space',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Display inline",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "vert_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Top' => 'top',
                                'Middle' => 'middle',
                                'Bottom' => 'bottom',
                                'Baseline' => 'baseline',
                            ),
                            "heading" => 'Vertical align',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "",
                            "info_img" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Style',
                            "value" => "",
                            "class" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Price color',
                            "param_name" => "price_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Currency color',
                            "param_name" => "curr_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_price', true, 'Price text' ),
                    td_config_helper::get_map_block_font_array( 'f_curr', false, 'Currency text' ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_plans_description',
			array(
				"map_in_td_composer" => true,
				"name" => 'Plans text switcher',
				"base" => 'tds_plans_description',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_plans_description.php',
                'tdc_style_params' => array(
                    'free_plan_desc',
                    'year_plan_desc',
                    'month_plan_desc',
                    'el_class',
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "year_plan_desc" => "JTJGeWVhcg==",
                                "month_plan_desc" => "JTJGJTIwbW9udGg=",
                            )
                        )
                    )
                ),
                "params" => array_merge(
					array(
                        array(
                            'param_name' => 'free_plan_desc',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Static text',
                            'description' => '',
                            'class' => 'tdc-textarea-exxtrasmall',
                            'toggle_enable_params' => 'free-plan-desc',
                            'toggle_enable_params_reverse' => true,
                        ),
						array(
	                        'param_name' => 'year_plan_desc',
	                        'type' => 'textarea_raw_html',
	                        'value' => '',
	                        'heading' => 'PLan 1 text',
	                        'description' => '',
	                        'class' => 'tdc-textarea-exxtrasmall',
                            'toggle_enabled_by' => 'free-plan-desc',
	                    ),
						array(
	                        'param_name' => 'month_plan_desc',
	                        'type' => 'textarea_raw_html',
	                        'value' => '',
	                        'heading' => 'Plan 2 text',
	                        'description' => '',
	                        'class' => 'tdc-textarea-exxtrasmall',
                            'toggle_enabled_by' => 'free-plan-desc',
	                    ),
                        array(
                            "param_name" => "inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Display inline",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "vert_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Top' => 'top',
                                'Middle' => 'middle',
                                'Bottom' => 'bottom',
                                'Baseline' => 'baseline',
                            ),
                            "heading" => 'Vertical align',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),
						array(
	                        "param_name" => "separator",
	                        "type" => "text_separator",
	                        "heading" => 'General style',
	                        "value" => "",
	                        "class" => "",
	                    ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "color",
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Links color',
                            "param_name" => "links_color",
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Links hover color',
                            "param_name" => "links_color_h",
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
					),
                    td_config_helper::get_map_block_font_array( 'f_descr', true, 'Description text' ),
					self::get_block_style()
                )
			)
		);

		td_api_block::add( 'tds_plans_switcher',
			array(
				"map_in_td_composer" => true,
				"name" => 'Plans switcher',
				"base" => 'tds_plans_switcher',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_plans_switcher.php',
				'tdc_style_params' => array(
                    'def_plan',
                    'tds_plans_switcher1-annual_txt',
                    'tds_plans_switcher1-monthly_txt',
				    'tds_plans_switcher2-annual_txt',
                    'tds_plans_switcher2-monthly_txt',
                    'el_class',
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
						array(
							array(
								'tds_plans_switcher1-annual_txt' => 'First plan pricing',
								'tds_plans_switcher1-monthly_txt' => 'Second plan pricing',
							)
						)
                    )
                ),
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "def_plan",
                            "type" => "dropdown",
                            "value" => array(
                                'Plan 1' => '',
                                'Plan 2' => 'monthly',
                            ),
                            "heading" => 'Default plan',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "tds_plans_switcher",
                            "type" => "dropdown",
                            "value" => td_api_style::get_styles_for_mapping( 'tds_plans_switcher', false ),
                            "heading" => 'Switcher style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-extrabig tdc-add-to-cart-btn-style",
                            "group" => "General",
                        ),
                    ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_subscription',
			array(
				"map_in_td_composer" => true,
				"name" => 'My subscription',
				"base" => 'tds_subscription',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_subscription.php',
				"params" => array_merge(
					array(
                    ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_dashboard',
			array(
				"map_in_td_composer" => true,
				"name" => 'Dashboard',
				"base" => 'tds_dashboard',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_dashboard.php',
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "custom_page_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => "Custom page id",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => ""
                        ),
                        array(
                            "param_name" => "show_notif",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show notifications",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                    ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_account_details',
			array(
				"map_in_td_composer" => true,
				"name" => 'Account details',
				"base" => 'tds_account_details',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_account_details.php',
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "custom_page_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => "Custom page id",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => ""
                        ),
                        array(
                            "param_name" => "show_notif",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show dummy data",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                    )
				)
			)
		);

        td_api_block::add( 'tds_payment',
            array(
                "map_in_td_composer" => true,
                "name" => 'Page checkout',
                "base" => 'tds_payment',
                'tdc_category' => 'Blocks',
                "file" => TDS_PATH . '/includes/shortcodes/tds_payment.php',
                'tdc_style_params' => array(
                    'show_version',
                    'success_url',
                    'default_payment',
                    'direct_txt',
                    'paypal_txt',
                    'stripe_txt',
                    'el_class',
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "show_version",
                            "type" => "dropdown",
                            "value" => array(
                                'Checkout form' => '',
                                'Checkout confirmation' => 'confirm',
                                'No plan selected' => 'no_plan',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'success_url',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Redirect if successful',
                            'description' => '',
                            'class' => 'tdc-textfield-extrabig',
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Payment methods',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "default_payment",
                            "type" => "dropdown",
                            "value" => array(
                                'Direct bank transfer' => 'direct',
                                'PayPal' => 'paypal',
                                'Stripe' => 'stripe',
                            ),
                            "heading" => 'Default payment method',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'direct_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Direct bank transfer label',
                            'description' => '',
                            'placeholder' => 'Direct Bank Transfer',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            'param_name' => 'paypal_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'PayPal label',
                            'description' => '',
                            'placeholder' => 'PayPal',
                            'class' => 'tdc-textfield-big',
                        ),
                        array(
                            'param_name' => 'stripe_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Stripe label',
                            'description' => '',
                            'placeholder' => 'Stripe',
                            'class' => 'tdc-textfield-big',
                        ),


                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'General',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Accent color',
                            "param_name" => "accent_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Links hover color',
                            "param_name" => "a_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_text', true, 'General text', '', '', 'tdc-s-global-font' ),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Sections',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Title color',
                            "param_name" => "sec_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Forms',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Billing details form',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "disable_bill",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Disable form",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "toggle_enable_params" => "disable_bill",
                            "toggle_enable_params_reverse" => true
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "bill_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                            "toggle_enabled_by" => "disable_bill"
                        ),
                        array(
                            "param_name" => "bill_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Padding",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "35px 25px",
                            "toggle_enabled_by" => "disable_bill"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Labels',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Inputs',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "input_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Placeholder text color',
                            "param_name" => "input_place_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "input_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "all_input_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border size",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "2"
                        ),
                        array(
                            "param_name" => "all_input_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "input_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_input_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Success accent color',
                            "param_name" => "input_succ_accent",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Error accent color',
                            "param_name" => "input_err_accent",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Subscription summary',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Head text color',
                            "param_name" => "tabl_head_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Head background color',
                            "param_name" => "tabl_head_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Body text color',
                            "param_name" => "tabl_body_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Footer text color',
                            "param_name" => "tabl_foot_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Lists',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Labels text color',
                            "param_name" => "list_label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Values text color',
                            "param_name" => "list_val_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Buttons',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "btn_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background hover color',
                            "param_name" => "btn_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Notification messages',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "notif_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Information accent color',
                            "param_name" => "notif_info_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Warning accent color',
                            "param_name" => "notif_warn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Error accent color',
                            "param_name" => "notif_error_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                    ),
                    self::get_block_style()
                )
            )
        );

		td_api_block::add( 'tds_my_account',
			array(
				"map_in_td_composer" => true,
				"name" => 'Page account',
				"base" => 'tds_my_account',
				'tdc_category' => 'Blocks',
                'tdc_style_params' => array(
                    'show_version',
                    'show_notif',
                    'enable_pag',
                    'per_page',
                    'el_class',
                ),
				"file" => TDS_PATH . '/includes/shortcodes/tds_my_account.php',
				"params" => array_merge(
                    array(
                        array(
                            "param_name" => "show_version",
                            "type" => "dropdown",
                            "value" => array(
                                'Dashboard' => '',
                                'Account settings' => 'settings',
                                'Subscriptions' => 'subscriptions',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'General',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Accent color',
                            "param_name" => "accent_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Links hover color',
                            "param_name" => "a_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_text', true, 'General text', '', '', 'tdc-s-global-font' ),

					array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Sections',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Title color',
                            "param_name" => "sec_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Description color',
                            "param_name" => "sec_descr_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Separators color',
                            "param_name" => "sec_sep_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Sidebar',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "side_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Width",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "200"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Right separator color',
                            "param_name" => "sep_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Navigation links',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "nav_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Icons color',
                            "param_name" => "nav_ico_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Background color',
                            "param_name" => "nav_ico_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Hover/active background color',
                            "param_name" => "nav_ico_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Forms',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Labels',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Tooltips text color',
                            "param_name" => "tip_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Tooltips background color',
                            "param_name" => "tip_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "tip_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Tooltips border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "2"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Inputs',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "input_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "input_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "all_input_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border size",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "2"
                        ),
                        array(
                            "param_name" => "all_input_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "input_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_input_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Tables',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Borders color',
                            "param_name" => "tabl_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Head text color',
                            "param_name" => "tabl_head_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Body text color',
                            "param_name" => "tabl_body_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => "Hover/expanded row background",
                            "param_name" => "tabl_hover_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => "Expanded row info background",
                            "param_name" => "tabl_info_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "enable_pag",
                            "type" => "checkbox",
                            "value" => 'yes',
                            "heading" => "Enable pagination",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "per_page",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => "Per page",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "10"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => "Pagination background color",
                            "param_name" => "pag_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => "Pagination background hover color",
                            "param_name" => "pag_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-triple-a",
                            "heading" => "Pagination text color",
                            "param_name" => "pag_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-triple-b",
                            "heading" => "Pagination text hover color",
                            "param_name" => "pag_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-triple-c",
                            "heading" => "Pagination text active color",
                            "param_name" => "pag_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Lists',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Labels text color',
                            "param_name" => "list_label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Values text color',
                            "param_name" => "list_val_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Buttons',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "btn_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background hover color',
                            "param_name" => "btn_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Publishing rights counters',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "pr_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Post type text color',
                            "param_name" => "pr_type_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Counter background color',
                            "param_name" => "pr_count_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Counter text color',
                            "param_name" => "pr_count_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "pr_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),


                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Notification messages',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "show_notif",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show in composer",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "notif_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Information accent color',
                            "param_name" => "notif_info_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Success accent color',
                            "param_name" => "notif_succ_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Error accent color',
                            "param_name" => "notif_error_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Pages',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            "group"      => "Custom pages"
                        ),
                        array(
                            "param_name" => "pages_header",
                            "type" => "pages_header",
                            "value" => "",
                            "class" => '',
                            "group" => 'Custom pages',
                            "id_heading_txt" => 'ID',
                        ),
                        array(
                            "param_name" => "page_0_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Dashboard page ID',
                            "description" => "",
                            "placeholder" => "Def",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_0_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Dashboard page title',
                            "description" => "",
                            "placeholder" => "Dashboard",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_0_tdicon',
                            'type' => 'icon',
                            'heading' => 'Dashboard page icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_6_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Account settings page ID',
                            "description" => "",
                            "placeholder" => "Def",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_6_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Dashboard page title',
                            "description" => "",
                            "placeholder" => "Account settings",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_6_tdicon',
                            'type' => 'icon',
                            'heading' => 'Account settings page icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_1_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 1 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_1_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 1 title',
                            "description" => "",
                            "placeholder" => "Page 1 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_1_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 1 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_2_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 2 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_2_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 2 title',
                            "description" => "",
                            "placeholder" => "Page 2 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_2_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 2 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_3_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 3 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_3_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 3 title',
                            "description" => "",
                            "placeholder" => "Page 3 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_3_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 3 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_4_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 4 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_4_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 4 title',
                            "description" => "",
                            "placeholder" => "Page 4 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_4_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 4 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_5_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 5 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_5_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 5 title',
                            "description" => "",
                            "placeholder" => "Page 5 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_5_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 5 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_7_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 6 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_7_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 6 title',
                            "description" => "",
                            "placeholder" => "Page 6 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_7_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 6 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_8_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 7 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_8_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 7 title',
                            "description" => "",
                            "placeholder" => "Page 7 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_8_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 7 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_9_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 8 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_9_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 8 title',
                            "description" => "",
                            "placeholder" => "Page 8 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_9_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 8 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_10_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 9 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_10_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 9 title',
                            "description" => "",
                            "placeholder" => "Page 9 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_10_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 9 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                        array(
                            "param_name" => "page_11_id",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 10 ID',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-id",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_11_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 10 title',
                            "description" => "",
                            "placeholder" => "Page 10 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            'param_name' => 'page_11_tdicon',
                            'type' => 'icon',
                            'heading' => 'Page 10 icon',
                            'class' => 'tdc-textfield-small tdc-page-controller tdc-page-icon',
                            'value' => '',
                            "group"       => 'Custom pages'
                        ),
                    ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_create_account',
			array(
				"map_in_td_composer" => true,
				"name" => 'Page login/register',
				"base" => 'tds_create_account',
				'tdc_category' => 'Blocks',
				"file" => TDS_PATH . '/includes/shortcodes/tds_create_account.php',
                'tdc_style_params' => array(
                    'show_version',
                    'success_url',
                    'show_notif',
                    'el_class',
                ),
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "show_version",
                            "type" => "dropdown",
                            "value" => array(
                                'Login' => '',
                                'Register' => 'register',
                                'Forgot password' => 'forgot_pass',
                                'Logged in' => 'logged_in',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Redirects',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "redirect_login_enable",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Redirect on login",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "toggle_enable_params" => "redirect_login",
                        ),
                        array(
                            'param_name' => 'redirect_login',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Redirect URL',
                            'description' => '',
                            'class' => 'tdc-textfield-extrabig',
                            "toggle_enabled_by" => "redirect_login",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "redirect_register_enable",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Redirect on register",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "toggle_enable_params" => "redirect_register",
                        ),
                        array(
                            'param_name' => 'redirect_register',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Redirect URL',
                            'description' => '',
                            'class' => 'tdc-textfield-extrabig',
                            "toggle_enabled_by" => "redirect_register",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'General',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Accent color',
                            "param_name" => "accent_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Links hover color',
                            "param_name" => "a_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_text', true, 'General text', '', '', 'tdc-s-global-font' ),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Sections',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Title color',
                            "param_name" => "sec_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Forms',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Helper text color',
                            "param_name" => "form_help_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Footer text color',
                            "param_name" => "form_foot_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Labels',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Tooltips text color',
                            "param_name" => "tip_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Tooltips background color',
                            "param_name" => "tip_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "tip_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Tooltips border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "2"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Inputs',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "input_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "input_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "all_input_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border size",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "2"
                        ),
                        array(
                            "param_name" => "all_input_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "input_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_input_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Buttons',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "param_name" => "btn_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background hover color',
                            "param_name" => "btn_bg_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "5"
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Notification messages',
                            "value" => "",
                            "class" => "",
                            "group" => '',
                        ),
                        array(
                            "param_name" => "show_notif",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show in composer",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "notif_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Border radius",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Information accent color',
                            "param_name" => "notif_info_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Success accent color',
                            "param_name" => "notif_succ_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Error accent color',
                            "param_name" => "notif_error_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                    ),
                    self::get_block_style()
				)
			)
		);

		td_api_block::add( 'tds_menu_login',
			array(
				'map_in_td_composer' => true,
				"name" => 'Menu login',
				"base" => "tds_menu_login",
				"class" => "",
				"controls" => "full",
				'tdc_category' => 'Blocks',
				'icon' => 'icon-pagebuilder-td_woo_menu_login',
				'file' => TDS_PATH . '/includes/shortcodes/tds_menu_login.php',
				'tdc_style_params' => array(
					'show_version',
					'guest_tdicon',
					'logout_tdicon',
					'menu_gh_txt',
					'menu_gc_btn1_txt',
					'menu_gc_btn2_txt',
					'el_class'
				),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								"inline" => "yes",
								"guest_tdicon" => "td-icon-profile",
								"logout_tdicon" => "td-icon-log-out",
							),
						)
					)
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "show_version",
							"type" => "dropdown",
							"value" => array(
								'Logged in version' => '',
								'Guest version' => 'guest',
							),
							"heading" => 'Show',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "dropdown_only",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Show dropdown only",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-ml-dropdown-only",
                            'toggle_enable_params' => 'dropdown-only',
                            'toggle_enable_params_reverse' => true
						),
						array(
							"param_name" => "disable_dropdown",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Disable dropdown menu",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-ml-disable-dropdown",
                            'toggle_enabled_by' => 'dropdown-only',
                            'toggle_enable_params' => 'disable-dropdown',
                            'toggle_enable_params_reverse' => true
						),
						array(
							"param_name" => "show_menu",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Show menu in composer",
							"description" => "",
							"holder" => "div",
							"class" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Toggle',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Guest',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							'param_name' => 'guest_tdicon',
							'type' => 'icon',
							'heading' => 'Icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							'param_name' => 'icon_size',
							'type' => 'range-responsive',
							'value' => '24',
							'heading' => 'Icon size',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '1',
							'range_max' => '60',
							'range_step' => '1',
							"group" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Logged in user',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "avatar_size",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Avatar size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "25",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "avatar_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Avatar radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "100",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name"  => "show_avatar",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'block',
								'Hide' => 'none',
							),
							"heading"     => 'Show avatar',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'General',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "ia_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon/avatar space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "12",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "toggle_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "My account",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "toggle_txt_pos",
							"type" => "dropdown",
							"value" => array(
								'After icon/avatar' => '',
								'Before icon/avatar' => 'before',
							),
							"heading" => 'Text position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "toggle_hide",
							"type" => "checkbox-responsive",
							"value" => '',
							"heading" => "Hide text",
							"description" => "",
							"holder" => "div",
							"class" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							'param_name' => 'toggle_txt_align',
							'type' => 'range-responsive',
							'value' => '0',
							'heading' => 'Text vert. position',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-10',
							'range_max' => '10',
							'range_step' => '1',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "toggle_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "inline",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Make inline",
							"description" => "",
							"holder" => "div",
							"class" => "",
                            'toggle_enabled_by' => 'dropdown-only',
						),

						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Menu',
							"value" => "",
							"class" => "tdc-separator tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_offset_top",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Menu top offset",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-hide",
							"placeholder" => "20",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							'param_name' => 'menu_offset_horiz',
							'type' => 'range-responsive',
							'value' => '8',
							'heading' => 'Menu horizontal offset',
							'description' => '',
							'class' => 'tdc-textfield-small tdc-ml-do-hide',
							'range_min' => '0',
							'range_max' => '100',
							'range_step' => '1',
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_width",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Width",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-hide",
							"placeholder" => "200",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "0",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "0",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_border_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "0",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Logged in menu',
							"value" => "",
							"class" => "tdc-separator tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_uh_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "11px 20px",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_uh_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border bottom size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "1",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_uh_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border bottom style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_ul_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "10px 20px",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_ul_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Links space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "0",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
                        array(
                            "param_name" => "menu_ul_sep_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Links separator space",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small tdc-ml-do-show",
                            "placeholder" => "8",
                            'toggle_enabled_by' => 'disable-dropdown',
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Footer',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_ulo_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Logout text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "Log out",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							'param_name' => 'logout_tdicon',
							'type' => 'icon',
							'heading' => 'Icon',
							'class' => 'tdc-textfield-small tdc-ml-do-show',
							'value' => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							'param_name' => 'logout_size',
							'type' => 'range-responsive',
							'value' => '14',
							'heading' => 'Icon size',
							'description' => '',
							'class' => 'tdc-textfield-small tdc-ml-do-show',
							'range_min' => '1',
							'range_max' => '60',
							'range_step' => '1',
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "logout_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "8",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_ulo_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "11px 20px",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_ulo_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border top size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "1",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_ulo_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border top style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Guest menu',
							"value" => "",
							"class" => "tdc-separator tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gh_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "Get into your account.",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gh_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "11px 20px",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gh_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border bottom size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "1",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gh_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border bottom style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => '',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "15px 20px",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn1_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Login button text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "Login",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn1_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Login button padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "9px 14px 11px",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn1_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Login button border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "0",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn1_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Login button border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn1_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Login button border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "0",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => "",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn2_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Signup button text",
							"description" => "Signup button will appear if you allow registration from WordPress settings.",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-ml-do-show",
							"placeholder" => "Register",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "menu_gc_btn2_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Signup button left space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-ml-do-show",
							"placeholder" => "12",
                            'toggle_enabled_by' => 'disable-dropdown',
						),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Pages',
                            "value" => "",
                            "class" => "tdc-separator",
                            "group" => 'Custom pages',
                        ),
                        array(
                            "param_name" => "pages_header",
                            "type" => "pages_header",
                            "value" => "",
                            "class" => 'tdc-pages-header-url-no-icon',
                            "group" => 'Custom pages',
                            "id_heading_txt" => 'URL/ID',
                        ),
                        array(
                            "param_name" => "page_0_url",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 1 URL',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-url",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_0_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 1 title',
                            "description" => "",
                            "placeholder" => "Page 1 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title tdc-page-title-medium",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_1_url",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 2 URL',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-url",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_1_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 2 title',
                            "description" => "",
                            "placeholder" => "Page 2 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title tdc-page-title-medium",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_2_url",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 3 URL',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-url",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_2_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 3 title',
                            "description" => "",
                            "placeholder" => "Page 3 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title tdc-page-title-medium",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_3_url",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 4 URL',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-url",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_3_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 4 title',
                            "description" => "",
                            "placeholder" => "Page 4 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title tdc-page-title-medium",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_4_url",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 5 URL',
                            "description" => "",
                            "placeholder" => "-",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-url",
                            'group'      => 'Custom pages',
                        ),
                        array(
                            "param_name" => "page_4_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Page 5 title',
                            "description" => "",
                            "placeholder" => "Page 5 title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-page-controller tdc-page-title tdc-page-title-medium",
                            'group'      => 'Custom pages',
                        ),

						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Toggle',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Icon color',
							"param_name" => "icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Icon hover color',
							"param_name" => "icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Text color',
							"param_name" => "toggle_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'dropdown-only',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Text hover color',
							"param_name" => "toggle_txt_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'dropdown-only',
						),
					),
                    td_util::get_display_restrictions_atts(),
                    td_config_helper::get_map_block_font_array( 'f_toggle', true, 'Toggle text', 'Style', '', 'tdc-ml-do-show', '', '', 'dropdown-only' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Menu',
							"value" => "",
							"class" => "tdc-separator tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Background',
							"param_name" => "menu_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Border color',
							"param_name" => "menu_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-hide",
							"heading" => 'Arrow color',
							"param_name" => "menu_arrow_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
					),
					td_config_helper::get_map_block_shadow_array('menu_shadow', 'Shadow', 6, 0, 2, 'Style', '', 0, true, 'tdc-ml-do-show', '', '', 'disable-dropdown' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Logged in menu',
							"value" => "",
							"class" => "tdc-separator tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Text color',
							"param_name" => "menu_uh_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Bottom border color',
							"param_name" => "menu_uh_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Links color',
							"param_name" => "menu_ul_link_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Links hover color',
							"param_name" => "menu_ul_link_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-ml-do-show",
                            "heading" => 'Links separator color',
                            "param_name" => "menu_ul_sep_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Footer',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Text color',
							"param_name" => "menu_uf_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Text hover color',
							"param_name" => "menu_uf_txt_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Icon color',
							"param_name" => "menu_uf_icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Icon hover color',
							"param_name" => "menu_uf_icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Top border color',
							"param_name" => "menu_uf_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Fonts',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_uh', true, 'Header text', 'Style', '', 'tdc-ml-do-show', '', '', 'disable-dropdown' ),
					td_config_helper::get_map_block_font_array( 'f_links', false, 'Links text', 'Style', '', 'tdc-ml-do-show', '', '', 'disable-dropdown' ),
					td_config_helper::get_map_block_font_array( 'f_uf', false, 'Footer text', 'Style', '', 'tdc-ml-do-show', '', '', 'disable-dropdown' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Guest menu',
							"value" => "",
							"class" => "tdc-separator tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Text color',
							"param_name" => "menu_gh_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-ml-do-show",
							"heading" => 'Bottom border color',
							"param_name" => "menu_gh_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Login button color',
							"param_name" => "menu_gc_btn1_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Login button hover color',
							"param_name" => "menu_gc_btn1_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Login button background color',
							"param_name" => "menu_gc_btn1_bg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Login button background hover color',
							"param_name" => "menu_gc_btn1_bg_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Login button border color',
							"param_name" => "menu_gc_btn1_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Login button border hover color',
							"param_name" => "menu_gc_btn1_border_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small tdc-ml-do-show",
							"group"       => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-ml-do-show",
							"heading" => 'Signup button color',
							"param_name" => "menu_gc_btn2_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-ml-do-show",
							"heading" => 'Signup button hover color',
							"param_name" => "menu_gc_btn2_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
                            'toggle_enabled_by' => 'disable-dropdown',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Fonts',
							"value" => "",
							"class" => "tdc-separator-small tdc-ml-do-show",
							"group" => 'Style',
                            'toggle_enabled_by' => 'disable-dropdown',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_gh', true, 'Header text', 'Style', '', 'tdc-ml-do-show', '', '', 'disable-dropdown' ),
					td_config_helper::get_map_block_font_array( 'f_btn1', false, 'Login button text', 'Style', '', 'tdc-ml-do-show', '', '', 'disable-dropdown' ),
					td_config_helper::get_map_block_font_array( 'f_btn2', false, 'Signup button text', 'Style', '', 'tdc-ml-do-show', '', '', 'disable-dropdown' ),

					self::get_block_style()
				)
			)
		);

	}

	static function get_block_style() {
		return array(
			array(
				"param_name" => "separator",
				"type" => "horizontal_separator",
				"value" => "",
				"class" => ""
			),
			array(
				'param_name' => 'el_class',
				'type' => 'textfield',
				'value' => '',
				'heading' => 'Extra class',
				'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
				'class' => 'tdc-textfield-extrabig',
			),
			array(
				'param_name' => 'tdc_css',
				'value' => '',
				'type' => 'tdc_css_editor',
				'heading' => '',
				'group' => 'Design options',
			)
		);
	}

    static function register_styles() {

        // Plans switcher styles
        td_api_style::add( 'tds_plans_switcher1', array(
                'group' => 'tds_plans_switcher',
                'title' => 'Style 1 - Simple switch',
                'file' => TDS_PATH . '/styles/tds_plans_switcher/tds_plans_switcher1.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Layout',
                            "value" => "",
                            'group' => 'General',
                        ),
                        array(
                            'param_name' => 'annual_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Plan 1 text',
                            'description' => '',
                            'placeholder' => '',
                            'class' => 'tdc-textfield-big',
                            'group' => 'General',
                        ),
                        array(
                            'param_name' => 'monthly_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Plan 2 text',
                            'description' => '',
                            'placeholder' => '',
                            'class' => 'tdc-textfield-big',
                            'group' => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "General",
                            "info_img" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Switch',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            'param_name' => 'switch_size',
                            'type' => 'range-responsive',
                            'value' => '2',
                            'heading' => 'Size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '1',
                            'range_max' => '4',
                            'range_step' => '1',
                            "info_img" => "",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "100",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_dot_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Dot border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_dot_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                                'Double' => 'double',
                            ),
                            "heading" => 'Dot border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "dot_border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Dot border radius',
                            "description" => "",
                            "placeholder" => "100%",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Labels',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "param_name" => "label_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "placeholder" => "12",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Style',
                            "value" => "",
                            'group' => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Switch',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "param_name" => "bg_color",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "General",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "dot_bg_color",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Dot background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "General",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Dot border color',
                            "param_name" => "all_dot_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('dot_shadow', 'Dot shadow', 3, 0, 1, 'General' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Labels',
                            "value" => "",
                            'group' => 'Labels',
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Text active color',
                            "param_name" => "label_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_label', true, 'Labels text', 'General' )
                )
            )
        );

        td_api_style::add( 'tds_plans_switcher2', array(
                'group' => 'tds_plans_switcher',
                'title' => 'Style 2 - Switch with text',
                'file' => TDS_PATH . '/styles/tds_plans_switcher/tds_plans_switcher2.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Layout',
                            "value" => "",
                            'group' => 'General',
                        ),
                        array(
                            'param_name' => 'annual_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Plan 1 text',
                            'description' => '',
                            'placeholder' => 'Annualy',
                            'class' => 'tdc-textfield-big',
                            'group' => 'General',
                        ),
                        array(
                            'param_name' => 'monthly_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Plan 1 text',
                            'description' => '',
                            'placeholder' => 'Monthly',
                            'class' => 'tdc-textfield-big',
                            'group' => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Switch',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "4",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "200",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "General",
                            "info_img" => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Labels',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "label_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "placeholder" => "13px 24px 14px",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_label_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border size',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "all_label_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "label_border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "placeholder" => "200",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => 'General',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Style',
                            "value" => "",
                            'group' => 'General',
                            "class" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Switch',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "bg_color",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Background color",
                            "value"      => "",
                            "class"      => "",
                            "group"      => "General",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            "heading" => 'Labels',
                            "value" => "",
                            'group' => 'General',
                            "class" => "tdc-separator-small",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Text active color',
                            "param_name" => "label_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "label_bg_color",
                            "holder"     => "div",
                            "type"       => "gradient",
                            'heading'    => "Active background color",
                            "value"      => "",
                            "class"      => "tdc-colorpicker-double-a",
                            "group"      => "General",
                            "info_img" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_label_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "General",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'General',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_label', true, 'Labels text', 'General' )
                )
            )
        );

    }

	static function get_lists() {

		// the lists tax is not registered at this point to get lists so we need to register it..
		td_subscription::register_taxonomy();

		// default list
		$default_list_id = (int) get_option( 'default_term_tds_list' );

		// get tds list taxonomies
		$tds_lists = get_terms( array(
			'taxonomy' => 'tds_list',
			'hide_empty' => false,
			'exclude' => array( $default_list_id ), // exclude default
		) );

		$lists = array(
			'Default List' => $default_list_id
		);

		if ( !empty( $tds_lists ) && is_array( $tds_lists ) ) {
			foreach ( $tds_lists as $list ) {
				$lists[$list->name] = $list->term_id;
			}
		}

		return $lists;

	}

	static function get_plans( $type = '', $for_config = true ) {

		if ( is_null(self::$day_plans) ||
            is_null(self::$week_plans) ||
            is_null(self::$month_plans) ||
            is_null(self::$year_plans) ||
            is_null(self::$unlimited_plans) ||
            is_null(self::$with_credits_plans) ||
            is_null(self::$donation_plans) ||
            is_null(self::$free_plans)
        ) {
			self::$day_plans = [];
			self::$week_plans = [];
			self::$month_plans = [];
			self::$year_plans = [];
			self::$unlimited_plans = [];
			self::$with_credits_plans = [];
			self::$donation_plans = [];
			self::$free_plans = [];

			global $wpdb;
			$plans = $wpdb->get_results("SELECT * FROM tds_plans");

			if ( null !== $plans ) {

				foreach ( $plans as $plan ) {

					$plan_free = false;
					$plan_unlimited = false;
					$plan_with_credit = false;
					$donation_plan = false;

                    if ( $plan->is_free == '1' ) {
                        self::$free_plans[$plan->id] = [
                            'name' => $plan->name,
                            'is_free' => $plan->is_free,
                        ];
                        $plan_free = true;
                    }

                    if ( !empty($plan->is_unlimited) && $plan->is_unlimited == '1' ) {
                        self::$unlimited_plans[$plan->id] = [
                            'name' => $plan->name,
                            'is_unlimited' => $plan->is_unlimited,
                            'price' => $plan->price,
                            'trial_days' => $plan->trial_days,
                        ];
                        $plan_unlimited = true;
                    }

                    if ( !empty($plan->is_with_credits) ) {
                        self::$with_credits_plans[$plan->id] = [
                            'name' => $plan->name,
                            'is_with_credits' => $plan->is_with_credits,
                            'price' => $plan->price
                        ];
                        $plan_with_credit = true;
                    }

                    if ( !empty($plan->is_donation) ) {
                        self::$donation_plans[$plan->id] = [
                            'name' => $plan->name,
                            'is_donation' => $plan->is_donation,
                            'price' => $plan->price
                        ];
                        $donation_plan = true;
                    }

					if ( $plan_free || $plan_unlimited || $plan_with_credit || $donation_plan ) {
						continue;
					}

					if ( empty($plan->interval) ) {
						continue;
					}

					switch ( $plan->interval ) {

						case 'day':

                            self::$day_plans[$plan->id] = [
                                'name' => $plan->name,
                                'price' => $plan->price,
                                'interval' => $plan->interval,
                                'interval_count' => $plan->interval_count,
                                'trial_days' => $plan->trial_days,
                            ];

						break;

						case 'week':

                            self::$week_plans[$plan->id] = [
                                'name' => $plan->name,
                                'price' => $plan->price,
                                'interval' => $plan->interval,
                                'interval_count' => $plan->interval_count,
                                'trial_days' => $plan->trial_days,
						    ];

						break;

						case 'month':

                            self::$month_plans[$plan->id] = [
                                'name' => $plan->name,
                                'price' => $plan->price,
                                'interval' => $plan->interval,
                                'interval_count' => $plan->interval_count,
                                'trial_days' => $plan->trial_days,
						    ];

						break;

						case 'year':

                            self::$year_plans[$plan->id] = [
                                'name' => $plan->name,
                                'price' => $plan->price,
                                'interval' => $plan->interval,
                                'interval_count' => $plan->interval_count,
                                'trial_days' => $plan->trial_days,
						    ];

						break;

					}

				}

			}

		}

		$current_plans = [];
        if ( !empty($type) ) {

            switch ($type) {
                case 'day' : $current_plans = self::$day_plans; break;
                case 'week' : $current_plans = self::$week_plans; break;
                case 'month' : $current_plans = self::$month_plans; break;
                case 'year' : $current_plans = self::$year_plans; break;
                case 'free' : $current_plans = self::$free_plans; break;
                case 'unlimited' : $current_plans = self::$unlimited_plans; break;
                case 'with_credit' : $current_plans = self::$with_credits_plans; break;
                case 'donation' : $current_plans = self::$donation_plans; break;
            }

        } else {

            if ( !empty(self::$day_plans) ) {

                if ( $for_config ) {
                    $current_plans['__day'] = '-- Day plans --';
                }

                $current_plans = $current_plans + self::$day_plans;
            }

            if ( !empty(self::$week_plans) ) {

                if ( $for_config ) {
                    $current_plans['__week'] = '-- Weekly plans --';
                }

                $current_plans = $current_plans + self::$week_plans;
            }

            if ( !empty(self::$month_plans) ) {

                if ( $for_config ) {
                    $current_plans['__month'] = '-- Monthly plans --';
                }

                $current_plans = $current_plans + self::$month_plans;
            }

            if ( !empty(self::$year_plans) ) {

                if ( $for_config ) {
                    $current_plans['__year'] = '-- Yearly plans --';
                }

                $current_plans = $current_plans + self::$year_plans;
            }

            if ( !empty(self::$unlimited_plans) ) {

                if ( $for_config ) {
                    $current_plans['__unlimited'] = '-- Unlimited plans --';
                }

                $current_plans = $current_plans + self::$unlimited_plans;
            }

            if ( !empty(self::$with_credits_plans) ) {

                if ( $for_config ) {
                    $current_plans['__credits'] = '-- Credits plans --';
                }

                $current_plans = $current_plans + self::$with_credits_plans;
            }

            if ( !empty(self::$donation_plans) ) {

                if ( $for_config ) {
                    $current_plans['__donation'] = '-- Donation plans --';
                }

                $current_plans = $current_plans + self::$donation_plans;
            }

        }

		if ( $for_config ) {
			$plans = [];
			$plans['No plan'] = '';

			foreach ( $current_plans as $id => $plan ) {

                if ( in_array( $id, [ '__day', '__week', '__month', '__year', '__unlimited', '__credits', '__donation' ] ) ) {
                    $plans[$plan] = $id;
                } else {
                    $plans[$plan['name'] . ' #' . $id] = $id;
                }

			}

			return $plans;

		}

		return $current_plans;

	}

}
