<?php
/**
 * Eastcoast Check Pro Demo Plugin Custom Modules & Styles Class
 */

class td_eastcoast_check_pro_demo_cm_styles {

	var $td_demo_cmstyles_path = '';
	var $td_demo_cmstyles_url = '';

    function __construct( $plugin_path, $plugin_url ) {

		$this->td_demo_cmstyles_path = $plugin_path;
		$this->td_demo_cmstyles_url = $plugin_url;

        // Hook used to add or modify items via API, called early for registering styles
        add_action( 'td_global_after', function() {
            self::register_styles();
            self::register_styles_2();
            self::register_styles_3();
        }, 9 );

        // Hook used to add or modify items via API
        add_action( 'td_global_after', function() {

            /**
             * Modules
             */
            td_api_module::add( 'tds_eastcoastcheck_module01',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_eastcoastcheck_module01.php',
                    'text'                         => 'East Coast Check Module 1',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );
            td_api_module::add( 'tds_eastcoastcheck_module02',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_eastcoastcheck_module02.php',
                    'text'                         => 'East Coast Check Module 2',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );
            td_api_module::add( 'tds_eastcoastcheck_module03',
                array(
                    'file'                         => $this->td_demo_cmstyles_path . '/includes/modules/tds_eastcoastcheck_module03.php',
                    'text'                         => 'East Coast Check Module 3',
                    'img'                          => '',
                    'used_on_blocks'               => array(),
                    'excerpt_title'                => 25,
                    'excerpt_content'              => 25,
                    'enabled_excerpt_in_panel'     => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops'             => false,
                    'uses_columns'                 => false,
                    // if the module uses columns on the page template + loop
                    'category_label'               => false,
                    'class'                        => 'td_module_wrap td-animation-stack',
                    'group'                        => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );
        });

	}

    /**
     * Modules styles
     */

    public function register_styles() {
        td_api_style::add( 'tds_eastcoastcheck_module_style01', array(
                'group' => 'tds_module_loop_style',
                'title' => 'East Coast Check Module 1',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_eastcoastcheck_module_style01.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "all_modules_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "34",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
//                        array(
//                            "param_name"  => "image_floated",
//                            "type"        => "dropdown-responsive",
//                            "value"       => array(
//                                'Normal'      => 'no_float',
//                                'Float left'  => 'float_left',
//                                'Float right' => 'float_right',
//                                'Hidden'      => 'hidden',
//                            ),
//                            "heading"     => 'Image position',
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "tdc-dropdown-big",
//                            "group"       => "Module",
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
//                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
//                        array(
//                            "param_name"  => "image_radius",
//                            "type"        => "textfield-responsive",
//                            "value"       => '',
//                            "heading"     => 'Image radius',
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "tdc-textfield-small",
//                            "placeholder" => "0",
//                            "group"       => "Module",
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
//                        ),
//                        array(
//                            "param_name"  => "hide_image",
//                            "type"        => "checkbox",
//                            "value"       => '',
//                            "heading"     => "Hide image",
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "",
//                            "group"       => 'Module',
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
//                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
                            "group" => "Module"
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'East Coast Check',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_flex",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '3 Columns'  => 'ecoast1_3_columns',
                                '2 Columns'  => 'ecoast1_2_columns',
                                'No Columns' => 'ecoast1_none',
                            ),
                            "heading"     => 'Columns',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Columns Width',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_column1_width_1ecoast",
                            "type"        => "textfield",
                            "value"       => "50px",
                            "heading"     => "Column 1 Width",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '35%',
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "td_ecoast1_icon_width",
                            "type"        => "textfield",
                            "value"       => "50px",
                            "heading"     => "Icon Width",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '',
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title & Description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_art_title_1ecoast', true, 'Article Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_description_1ecoast', false, 'Description', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Amenities',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_wifi_1ecoast', false, 'Wifi Options', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_schedule_1ecoast', false, 'Schedule', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_aircon_1ecoast', false, 'Air Conditioning', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_smoking_1ecoast', false, 'Smoking Section', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_parking_1ecoast', false, 'Parking', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_payment_1ecoast', false, 'Payment Options', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Contact',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_emaillabel_1ecoast', false, 'Email Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_email_1ecoast', false, 'Email Address', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_websitelabel_1ecoast', false, 'Website Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_website_1ecoast', false, 'Website Address', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_phonelabel_1ecoast', false, 'Phone Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_phone_1ecoast', false, 'Phone Number', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Margins and Paddings',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_title_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_amenities_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Amenities Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_mid_amenities_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Middle Amenities Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_amenicon_pa",
                            "type"        => "textfield-responsive",
                            "value"       => '2px 5px',
                            "heading"     => 'Amenities Icon Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_amenicon_br",
                            "type"        => "textfield-responsive",
                            "value"       => '50%',
                            "heading"     => 'Amenities Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast1_contact_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '2px 5px',
                            "heading"     => 'Mid Contact Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_eastcoast1_title_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title Color Hover',
                            "param_name"  => "td_eastcoast1_title_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Description Color',
                            "param_name"  => "td_eastcoast1_description_co",
                            "value"       => 'blue',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Amenity Icon Color',
                            "param_name"  => "td_eastcoast1_icon_co",
                            "value"       => 'blue',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Amenity Icon Background',
                            "param_name"  => "td_eastcoast1_bg_icon_co",
                            "value"       => 'blue',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Amenities Color',
                            "param_name"  => "td_eastcoast1_amenities_co",
                            "value"       => 'blue',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Contact Label Color',
                            "param_name"  => "td_eastcoast1_contla_co",
                            "value"       => 'blue',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Contact Color',
                            "param_name"  => "td_eastcoast1_contact_co",
                            "value"       => 'blue',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    )
                )
            )
        );
    }

    public function register_styles_2() {
        td_api_style::add( 'tds_eastcoastcheck_module_style02', array(
                'group' => 'tds_module_loop_style',
                'title' => 'East Coast Check Module 2',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_eastcoastcheck_module_style02.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "all_modules_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "34",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
//                        array(
//                            "param_name"  => "image_floated",
//                            "type"        => "dropdown-responsive",
//                            "value"       => array(
//                                'Normal'      => 'no_float',
//                                'Float left'  => 'float_left',
//                                'Float right' => 'float_right',
//                                'Hidden'      => 'hidden',
//                            ),
//                            "heading"     => 'Image position',
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "tdc-dropdown-big",
//                            "group"       => "Module",
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
//                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
//                        array(
//                            "param_name"  => "image_radius",
//                            "type"        => "textfield-responsive",
//                            "value"       => '',
//                            "heading"     => 'Image radius',
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "tdc-textfield-small",
//                            "placeholder" => "0",
//                            "group"       => "Module",
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
//                        ),
//                        array(
//                            "param_name"  => "hide_image",
//                            "type"        => "checkbox",
//                            "value"       => '',
//                            "heading"     => "Hide image",
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "",
//                            "group"       => 'Module',
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
//                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
                            "group" => "Module"
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'East Coast Check',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Meta Info',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_meta_pad",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta Info Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_meta_br",
                            "type"        => "textfield-responsive",
                            "value"       => '4px',
                            "heading"     => 'Meta Info Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_meta_bstyle",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Meta Info Border Style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_meta_bwidth",
                            "type"        => "textfield-responsive",
                            "value"       => '2px',
                            "heading"     => 'Meta Info Border Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta Info Color',
                            "param_name"  => "td_ecoast2_meta_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta Info Border Color',
                            "param_name"  => "td_ecoast2_meta_bco",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('td_ecoast2_meta_shadow', 'Meta Info Shadow', 0, 0, 0, "Module", '', 0, true, '', '', '' ),
                    td_config_helper::get_map_block_shadow_array('td_ecoast2_module_shadow', 'Module Shadow', 0, 0, 0, "Module", '', 0, true, '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Margins and Paddings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_title_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_iconcf_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Wifi Icon Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_iconcf_pa",
                            "type"        => "textfield-responsive",
                            "value"       => '7px 5px 2px 6px',
                            "heading"     => 'Wifi Icon Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_location_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Location Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_icon_width",
                            "type"        => "textfield-responsive",
                            "value"       => '20px',
                            "heading"     => 'Wifi Icon Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_icon_br",
                            "type"        => "textfield-responsive",
                            "value"       => '50%',
                            "heading"     => 'Icon Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Taxonomy Icon',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_taxicon_br",
                            "type"        => "textfield-responsive",
                            "value"       => '50%',
                            "heading"     => 'Taxonomy Icon Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_taxicon_pa",
                            "type"        => "textfield-responsive",
                            "value"       => '7px 5px 2px 6px',
                            "heading"     => 'Taxonomy Icon Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_taxicon_width",
                            "type"        => "textfield-responsive",
                            "value"       => '20px',
                            "heading"     => 'Taxonomy Icon Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast2_taxicon_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Taxonomy Icon Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_ecoast2_art_title', true, 'Article Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_ecoast2_wificf', false, 'Wifi Font', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_ecoast2_location_la', false, 'Location Label', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_ecoast2_tax_locations', false, 'Locations Font', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_ecoast2_title_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title Color Hover',
                            "param_name"  => "td_ecoast2_title_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Wifi Icon Color',
                            "param_name"  => "td_ecoast2_icon_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Wifi Icon Background Color',
                            "param_name"  => "td_ecoast2_icon_bg_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Wifi Text Color',
                            "param_name"  => "td_ecoast2_wifi_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Location Label Color',
                            "param_name"  => "td_ecoast2_locationla_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Locations Color',
                            "param_name"  => "td_ecoast2_locations_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Locations Color Hover',
                            "param_name"  => "td_ecoast2_locations_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Taxonomy Icon Color',
                            "param_name"  => "td_ecoast2_taxicon_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Taxonomy Icon Color Hover',
                            "param_name"  => "td_ecoast2_taxicon_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Taxonomy Background Color',
                            "param_name"  => "td_ecoast2_taxbg_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Taxonomy Background Color Hover',
                            "param_name"  => "td_ecoast2_taxbg_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),

                    )
                )
            )
        );
    }

    public function register_styles_3() {
        td_api_style::add( 'tds_eastcoastcheck_module_style03', array(
                'group' => 'tds_module_loop_style',
                'title' => 'East Coast Check Module 3',
                'file' => $this->td_demo_cmstyles_path . '/includes/styles/tds_module_loop_style/tds_eastcoastcheck_module_style03.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),


                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '48',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name"  => "all_modules_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "34",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                        ),
                        array(
                            "param_name"  => "m_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Border',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "modules_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name"  => "modules_border_style",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "modules_border_color",
                            "value"       => '#eaeaea',
                            "description" => '',
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name"  => "image_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
//                        array(
//                            "param_name"  => "image_floated",
//                            "type"        => "dropdown-responsive",
//                            "value"       => array(
//                                'Normal'      => 'no_float',
//                                'Float left'  => 'float_left',
//                                'Float right' => 'float_right',
//                                'Hidden'      => 'hidden',
//                            ),
//                            "heading"     => 'Image position',
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "tdc-dropdown-big",
//                            "group"       => "Module",
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
//                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name"  => "image_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),
//                        array(
//                            "param_name"  => "hide_image",
//                            "type"        => "checkbox",
//                            "value"       => '',
//                            "heading"     => "Hide image",
//                            "description" => "",
//                            "holder"      => "div",
//                            "class"       => "",
//                            "group"       => 'Module',
//                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
//                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "mc1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name"  => "mc1_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
                            "group" => "Module"
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    td_config::get_map_exclusive_label_array(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'East Coast Check',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Margins and Paddings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_module_pa",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Module Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_metainfo_pa",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta Info Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_title_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_location_ma",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Location Margins',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_taxicon_pa",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Taxonomy Icon Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_module_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Module Border',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_module_br",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Module Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_taxicon_br",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Taxonomy Icon Border Radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name"  => "td_ecoast3_taxicon_width",
                            "type"        => "textfield-responsive",
                            "value"       => '20px',
                            "heading"     => 'Taxonomy Icon Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "",
                            "group"       => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_ecoast3_title', true, 'Article Title', "Module", '', '', '', '' ),
                    td_config_helper::get_map_block_font_array( 'f_ecoast3_locations', false, 'Locations Font', "Module", '', '', '', '' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title Color',
                            "param_name"  => "td_ecoast3_title_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title Color Hover',
                            "param_name"  => "td_ecoast3_title_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Location Color',
                            "param_name"  => "td_ecoast3_location_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Location Color Hover',
                            "param_name"  => "td_ecoast3_location_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Taxonomy Icon Color',
                            "param_name"  => "td_ecoast3_taxicon_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Taxonomy Icon Color Hover',
                            "param_name"  => "td_ecoast3_taxicon_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Taxonomy Background Color',
                            "param_name"  => "td_ecoast3_taxicon_bg_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Taxonomy Background Color Hover',
                            "param_name"  => "td_ecoast3_taxicon_bg_coho",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Module Background Color',
                            "param_name"  => "td_ecoast3_module_bg_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Module Border Color',
                            "param_name"  => "td_ecoast3_module_border_co",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Module",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('td_ecoast3_module_shadow_out', 'Outer Module Shadow', 0, 0, 0, "Module", '', 0, true, '', '', '' ),
                    td_config_helper::get_map_block_shadow_array('td_ecoast3_module_shadow_inner', 'Inner Module Shadow', 0, 0, 0, "Module", '', 0, true, '', '', '' )
                )
            )
        );
    }

}

