<?php

    if ( !function_exists('td_get_post_by_ids_autocomplete') ) {
        /**
         * Autocomplete by post ids.
         *
         * @param array $ids Posts ids.
         *
         * @return array
         */
        function td_get_post_by_ids_autocomplete( $ids ) {
            $output = [];

            if ( !$ids ) {
                return $output;
            }

            if ( !is_array($ids) ) {
                $ids = [ $ids ];
            }

            foreach ( $ids as $id ) {
                $post = get_post( $id );

                if ( $post ) {
                    $output[$post->ID] = array(
                        'name'  => $post->post_title . ' ID:(' . $post->ID . ')',
                        'value' => $post->ID,
                    );
                }
            }

            return $output;
        }
    }

    if ( !function_exists('td_product_attributes_array') ) {
        function td_product_attributes_array() {

            if ( !function_exists('wc_get_attribute_taxonomies') ) {
                return [];
            }
            $attributes = [];

            foreach ( wc_get_attribute_taxonomies() as $attribute ) {
                $attributes[ 'pa_' . $attribute->attribute_name ] = array(
                    'name'  => $attribute->attribute_label,
                    'value' => 'pa_' . $attribute->attribute_name,
                );
            }

            return $attributes;
        }
    }

?>

<script>

    ( function($) {

        $(document).ready(function() {

            if ( typeof ($.fn.select2) === 'undefined' ) {
                console.log('select2 undefined');
                return;
            }

            $('.tdw-lv-products select').each( function() {
                var $field = $(this);
                var type = $field.data('type');
                var value = $field.data('value');
                var search = $field.data('search');

                if ( $field.hasClass('tdw-field-inited')  ) {
                    return;
                }

                $field.select2({
                    width      : '100%',
                    allowClear : true,
                    theme      : 'tdw',
                    tags       : true,
                    placeholder: '-- Select --',
                    ajax: {
                        url: td_ajax_url,
                        dataType: 'json',
                        delay: 250,
                        method: 'POST',
                        data: function (params) {
                            return {
                                action: search,
                                type  : type,
                                value : value,
                                selected : $field.val(),
                                params: params
                            };
                        },
                        processResults: function (data) {
                            $.each(data, function ( $key, $item ) {
                                $item['text'] = $item['text'].replace('&amp;', '&');
                                data[$key] = $item;
                            });

                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    dropdownCssClass: 'tdb-s-select2',
                    // templateResult: function ( term_data ) {},
                    // templateSelection: function ( data ) {
                    //     jQuery( data.element ).attr('data-term-slug', data.slug );
                    //     return data.text;
                    // }
                }).on('select2:select select2:unselect', function(e) {
                    // $(e.currentTarget).find('option').each(function(e) {
                    // 	$(this).removeAttr('selected');
                    // });
                });

                $field.addClass('tdw-field-inited');

            });

            $('.tdw-lv-attributes select, .tdw-lv-img-attribute select').each( function() {

                var select2Defaults = {
                    width      : '100%',
                    allowClear : true,
                    theme      : 'tdw',
                    tags       : true,
                    placeholder: 'Select'
                };

                var $select2 = $(this);
                if ( $select2.hasClass('tdw-field-inited') ) {
                    return;
                }

                if ( $select2.attr('multiple') ) {

                    $select2.on('select2:select', function(e) {
                        var $elm = $(e.params.data.element);

                        console.log($elm);

                        $(this).find('option[value=""]').prop('selected', false);

                        $elm.attr('selected', 'selected');
                        $select2.append($elm);
                        $select2.trigger('change.select2');
                    });

                    $select2.on('select2:unselect', function(e) {
                        var $this = $(this);
                        var $elm  = $(e.params.data.element);

                        $elm.removeAttr('selected');
                        $select2.trigger('change.select2');

                        if ( 0 === $this.find('option[selected="selected"]').length ) {
                            $this.find('option[value=""]').prop('selected', 'selected');
                        }
                    });

                    // $select2.parent().find('.xts-select2-all').on('click', function(e) {
                    //     e.preventDefault();
                    //
                    //     $select2.select2('destroy')
                    //         .find('option')
                    //         .each( function (key, option) {
                    //             var $option = $(option);
                    //
                    //             if ( 0 === $option.val().length ) {
                    //                 $option.prop('selected', false);
                    //             } else {
                    //                 $option.attr('selected', 'selected');
                    //                 $option.prop('selected', 'selected');
                    //             }
                    //         })
                    //         .end()
                    //         .select2(select2Defaults);
                    // });

                    // $select2.parent().find('.xts-unselect2-all').on('click', function(e) {
                    //     e.preventDefault();
                    //
                    //     $select2.select2('destroy')
                    //         .find('option')
                    //         .each( function (key, option) {
                    //             var $option = $(option);
                    //
                    //             if ( 0 === $option.val().length ) {
                    //                 $option.prop('selected', 'selected');
                    //             } else {
                    //                 $option.attr('selected', false);
                    //                 $option.prop('selected', false);
                    //             }
                    //         })
                    //         .end()
                    //         .select2(select2Defaults);
                    // });

                }

                $select2.select2(select2Defaults);
                $select2.addClass('tdw-field-inited');

            });

        });

    })(jQuery);

</script>

<style>

    .wp-admin .select2-container--tdw .select2-selection--multiple {
        min-height: 25px !important;
        cursor: text;
    }

    .wp-admin .select2-container--tdw .select2-selection--multiple ul,
    .wp-admin .select2-container--tdw .select2-selection--multiple ul li {
        margin: 0;
    }

    .wp-admin .select2-container--tdw .select2-selection {
        outline: 0;
        border-width: 1px;
        border-style: solid;
        border-color: #ddd !important;
        border-radius: 0;
        background-color: #FFF;
    }

    .wp-admin .select2-container--tdw .select2-search--inline .select2-search__field {
        width: auto !important;
        height: 30px;
        outline: 0;
        border: none !important;
        box-shadow: none;
        font-size: 14px;
    }

    .td-meta-box-inside {
        padding: 10px 12px !important;
    }

    .td-meta-box-inside .td-op-section .td-op-section-title {
        background-color: #f4f4f4;
        padding: 10px 24px;
        color: #222;
        margin: 0 -24px;
    }

    .td-meta-box-inside .td-op-section .td-meta-box-row {
        margin: 15px 0 30px;
    }

    .td-meta-box-inside .select2-selection__clear {
        font-size: 20px;
        cursor: pointer;
        position: relative;
        top: 3px;
    }

    .td-meta-box-inside .select2-selection__choice__remove {
        font-size: 20px;
        cursor: pointer;
        position: relative;
        top: 1px;
        margin-right: 6px;
    }

    .td-meta-box-inside .select2-selection__choice__remove:hover,
    .td-meta-box-inside .select2-selection__clear:hover {
        color: red;
    }

</style>

<div class="td-meta-box-inside" style="border-top: 0;">

	<div class="td-page-option-panel td-post-option-general td-page-option-panel-active td-woo-lv-settings">

        <?php
            //echo '<pre>';
                //print_r($mb);
                //print_r( get_post_meta( $mb->current_post_id, 'td_woo_lv_settings', true ) );
            //echo '</pre>';
        ?>

        <div class="td-op-section">

            <h3 class="td-meta-box-col-title td-op-section-title">Products</h3>
            <div class="td-op-meta-box-row tdw-lv-products">

                <div class="td-meta-box-col td-meta-box-col-layout">

                    <div class="td-meta-box-row" style="padding: 0;">
                        <?php

                            $mb->the_field( 'linked_products', WPALCHEMY_FIELD_HINT_SELECT_MULTI );

                            $name = $mb->get_the_name();
                            $value = $mb->get_the_value();

                            $options = td_get_post_by_ids_autocomplete($value);

                        ?>

                        <select id="tdw-lv-products" class="tdw-select tdw-select2 tdw-autocomplete" name="<?php echo esc_attr($name); ?>" multiple data-type="post" data-value="product" data-search="td_get_post_by_query_autocomplete" aria-label="<?php echo esc_attr($name); ?>">
                            <option value="">Select</option>
                                <?php
                                foreach ( $options as $option ) {

                                    $selected = false;
                                    if ( is_array($value) && in_array( $option['value'], $value ) ) {
                                        $selected = true;
                                    } elseif ( !is_array($value) && strval($value) === strval($option['value']) ) {
                                        $selected = true;
                                    }

                                    ?>
                                    <option value="<?php echo esc_attr( $option['value'] ); ?>" <?php selected( true, $selected ); ?>>
                                        <?php echo esc_html( $option['name'] ); ?>
                                    </option>
                                    <?php

                                }
                                ?>
                        </select>

                        <span class="td-page-o-info">Select products that will be a part of the bundle as variations.</span>
                    </div>

                </div>

            </div>

            <h3 class="td-meta-box-col-title td-op-section-title">Attributes</h3>
            <div class="td-op-meta-box-row tdw-lv-attributes">

                <div class="td-meta-box-col td-meta-box-col-layout">

                    <div class="td-meta-box-row" style="padding: 0;">
                        <?php

                            $mb->the_field( 'linked_attrs', WPALCHEMY_FIELD_HINT_SELECT_MULTI );

                            $name = $mb->get_the_name();
                            $value = $mb->get_the_value();

                            $options = td_product_attributes_array();

                        ?>

                        <select id="tdw-lv-attributes" class="tdw-select tdw-select2" name="<?php echo esc_attr($name); ?>" multiple aria-label="<?php echo esc_attr($name); ?>">
                            <option value="">Select</option>
                                <?php
                                foreach ( $options as $option ) {

                                    $selected = false;
                                    if ( is_array($value) && in_array( $option['value'], $value ) ) {
                                        $selected = true;
                                    } elseif ( !is_array($value) && strval($value) === strval($option['value']) ) {
                                        $selected = true;
                                    }

                                    ?>
                                    <option value="<?php echo esc_attr( $option['value'] ); ?>" <?php selected( true, $selected ); ?>>
                                        <?php echo esc_html( $option['name'] ); ?>
                                    </option>
                                    <?php

                                }
                                ?>
                        </select>

                        <span class="td-page-o-info">These attributes will be used to connect selected products with each other.</span>
                    </div>

                </div>

            </div>

            <h3 class="td-meta-box-col-title td-op-section-title">Attribute for the product image</h3>
            <div class="td-op-meta-box-row tdw-lv-img-attribute">

                <div class="td-meta-box-col td-meta-box-col-layout">

                    <div class="td-meta-box-row" style="padding: 0;">
                        <?php

                            $mb->the_field( 'linked_image_attr', WPALCHEMY_FIELD_HINT_SELECT_MULTI );

                            $name = $mb->get_the_name();
                            $value = $mb->get_the_value();

                            $options = td_product_attributes_array();

                        ?>

                        <select id="tdw-lv-img-attribute" class="tdw-select tdw-select2" name="<?php echo esc_attr($name); ?>" multiple aria-label="<?php echo esc_attr($name); ?>">
                            <option value="">Select</option>
                                <?php
                                foreach ( $options as $option ) {

                                    $selected = false;
                                    if ( is_array($value) && in_array( $option['value'], $value ) ) {
                                        $selected = true;
                                    } elseif ( !is_array($value) && strval($value) === strval($option['value']) ) {
                                        $selected = true;
                                    }

                                    ?>
                                    <option value="<?php echo esc_attr( $option['value'] ); ?>" <?php selected( true, $selected ); ?>>
                                        <?php echo esc_html( $option['name'] ); ?>
                                    </option>
                                    <?php

                                }
                                ?>
                        </select>

                        <span class="td-page-o-info">Select an attribute that will be shown as product images.</span>
                    </div>

                </div>

            </div>


        </div>

        <!--<div class="td-op-section">-->
            <!--<h3 class="td-meta-box-col-title td-meta-box-col-title-cl td-op-section-title">Other Options</h3>-->
            <!--<div class="td-op-meta-box-row"></div>-->
        <!--</div>-->

	</div>

</div>
